/*------------------------------POTIS.CPP------------------------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Sample for adjusting the EEPROM Poteniometers 

  V 1.00
  April 1996
 ---------------------------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>
#include <fstream.h>
#include "ik341.h"
#include "ik341_1.h"
extern "C" {
#include "vmerotec.h"
};


/****************************************************************************/
/**		Globals                                                           **/
/****************************************************************************/
extern unsigned char iic_error;



const unsigned short Adr_Ik341[] =
{
0,
(DIP_SWITCH_CARD1 >>1) * 0x0200,
(DIP_SWITCH_CARD2 >>1) * 0x0200,
(DIP_SWITCH_CARD3 >>1) * 0x0200,
(DIP_SWITCH_CARD4 >>1) * 0x0200,
(DIP_SWITCH_CARD5 >>1) * 0x0200,
(DIP_SWITCH_CARD6 >>1) * 0x0200,
(DIP_SWITCH_CARD7 >>1) * 0x0200,
(DIP_SWITCH_CARD8 >>1) * 0x0200,
(DIP_SWITCH_CARD9 >>1) * 0x0200,
(DIP_SWITCH_CARD10 >>1) * 0x0200,
(DIP_SWITCH_CARD11 >>1) * 0x0200,
(DIP_SWITCH_CARD12 >>1) * 0x0200,
(DIP_SWITCH_CARD13 >>1) * 0x0200,
(DIP_SWITCH_CARD14 >>1) * 0x0200,
(DIP_SWITCH_CARD15 >>1) * 0x0200,
(DIP_SWITCH_CARD16 >>1) * 0x0200
};

const unsigned short VmeA16Adr_Ik341[] =
{
0,
((((DIP_SWITCH_CARD1 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD2 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD3 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD4 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD5 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD6 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD7 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD8 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD9 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD10 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD11 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD12 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD13 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD14 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD15 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00,
((((DIP_SWITCH_CARD16 >>1) * 0x0200) & 0x8000) >>8) | 0xfc00
};

unsigned short Card_Adr;             

/*--------------------------------------------------------------------
								main
 --------------------------------------------------------------------- */

int main()
{
pCard board;
VmeInit();
board = new struct cardc;
for(int i=1;i<=16;i++)
	{
	if(Adr_Ik341[i] != 0x0000)
		{
		board->card[i] = new struct ik341;
		board->card[i]->axis[1] = new struct g26;
		board->card[i]->axis[2] = new struct g26;
		board->card[i]->axis[3] = new struct g26;
		board->card[i]->axis[4] = new struct g26;
		Card_Adr = Adr_Ik341[i] | 0x8000;
		outport(ADR_REG,VmeA16Adr_Ik341[i]);	//switch to VME A16 memory space
		InitIk341(board->card[i]);
		if (!LookforIk341(board->card[i]))
			{
			cout << "\n Ik341 number" << i  << " is missing";
			exit(-1);
			}
		}
	}

outport(ADR_REG,VmeA16Adr_Ik341[1]);	//switch to VME A16 memory space

CrtInit();
ShowPotis(board->card[1]);
TurnPotis(board->card[1]);			
 
textbackground(BLACK);
textcolor(WHITE);
window(1,1,80,25);
clrscr();

for(int j=1;j<=16;j++)
	{
	if(Adr_Ik341[j] != 0x0000)
		{
		delete board->card[j]->axis[1];
		delete board->card[j]->axis[2];
		delete board->card[j]->axis[3];
		delete board->card[j]->axis[4];
		delete board->card[j];
		}
	 }
delete board;			 		  
return (0);
}
  