UNIT DLLFunc;

interface
(******************************************************************)
uses
  Windows;
(******************************************************************)
(* Typen                                                          *)
(******************************************************************)
type
	Long8		= array [0..7] of LongInt;
	Long8Ptr	= ^Long8;
	BytePtr		= ^Byte;
	TCharPtr	=  array [0..255] of Char;
	CharPtr     = ^TCharPtr;
	IntPtr		= ^SmallInt;
	WordPtr		= ^Word;
	Bool32		=  LongInt;
	Bool32Ptr	= ^Bool32;
	LongPtr		= ^LongInt;
	DoublePtr	= ^Double;


(******************************************************************)
(* DLL-functions                                                  *)
(******************************************************************)
Function IKFind			(pBuffer8: Long8Ptr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKInit			(Axis: Word; Mode: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKVersion		(Axis: Word; pVersCard: CharPtr; pVersDrv: CharPtr; pVersDll: CharPtr) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKReset		(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKStart		(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKStop			(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKClear		(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKLatch		(Axis: Word; Latch: Word) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKResetREF		(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKStartREF		(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKStopREF		(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKLatchREF		(Axis: Word; Latch: Word) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKLatched		(Axis: Word; Latch: Word; pStatus: Bool32Ptr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKWaitLatch	(Axis: Word; Latch: Word) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKStrtCodRef	(Axis: Word; Latch: Word; RefDist: LongInt) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKCodRef 		(Axis: Word; pStatus: Bool32Ptr; pData: DoublePtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKWaitCodRef 	(Axis: Word; pData: DoublePtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKStopCodRef	(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKStatus		(Axis: Word; pStatus: LongPtr) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKRead32		(Axis: Word; Latch: Word; pData: LongPtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKRead48		(Axis: Word; Latch: Word; pData: DoublePtr) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKReadPhase	(Axis: Word; pData: BytePtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKWritePhase	(Axis: Word;  Data: Byte) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKLoadPhase	(Axis: Word; pData: BytePtr) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKReadAmp		(Axis: Word; pData: BytePtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKWriteAmp		(Axis: Word;  Data: Byte) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKLoadAmp		(Axis: Word; pData: BytePtr) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKReadOffset	(Axis: Word; Ofs0: IntPtr;  Ofs90: IntPtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKWriteOffset	(Axis: Word; Ofs0: Integer; Ofs90: Integer) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKLoadOffset	(Axis: Word; Ofs0: IntPtr;  Ofs90: IntPtr) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKStore		(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKDefault		(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKRomRead		(Card: Word; Adr: Byte; Data: BytePtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKRomWrite		(Card: Word; Adr: Byte; Data: Byte) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKInputW		(Axis: Word; Adr: Word; pData: WordPtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKInputL		(Axis: Word; Adr: Word; pData: LongPtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKOutput		(Axis: Word; Adr: Word;   Data: LongInt) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKSetI2C		(Card: Word; SCL: Bool32; SDA: Bool32) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKDefine		(pBuffer8: Long8Ptr) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKSetTimer		(Axis: Word; SetVal: Word) : Bool32; StdCall; External 'IK121DLL.DLL';

Function IKEnableLatch	(Axis: Word; Latch: Word; Source: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKEnableSync	(Card: Word; Source: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKLatchAll		(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
