// IK121TST.h : main header file for the IK121TST application
//

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"		// main symbols

/////////////////////////////////////////////////////////////////////////////
// CIK121TSTApp:
// See IK121TST.cpp for the implementation of this class
//

class CIK121TSTApp : public CWinApp
{
public:
	CIK121TSTApp();


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CIK121TSTApp)
	public:
	virtual BOOL InitInstance();
	//}}AFX_VIRTUAL

// Implementation

	//{{AFX_MSG(CIK121TSTApp)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////


#ifdef __cplusplus
extern "C"
{
#endif
	WINUSERAPI BOOL WINAPI IKDefine			(ULONG* pBuffer8);
	WINUSERAPI BOOL WINAPI IKFind	        (ULONG*  pBuffer8);
	WINUSERAPI BOOL WINAPI IKInit	        (USHORT Axis, USHORT Mode);

	WINUSERAPI BOOL WINAPI IKReset	        (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKStart	        (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKStop	        (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKLatch          (USHORT Axis, USHORT Latch);

	WINUSERAPI BOOL WINAPI IKResetREF       (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKStartREF       (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKStopREF        (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKLatchREF       (USHORT Axis, USHORT Latch);

	WINUSERAPI BOOL WINAPI IKLatched        (USHORT Axis, USHORT Latch, BOOL* pStatus);
	WINUSERAPI BOOL WINAPI IKWaitLatch      (USHORT Axis, USHORT Latch);

	WINUSERAPI BOOL WINAPI IKStrtCodRef     (USHORT Axis, USHORT Latch, ULONG RefDist);
	WINUSERAPI BOOL WINAPI IKCodRef	        (USHORT Axis, BOOL* pStatus, double* pData);
	WINUSERAPI BOOL WINAPI IKWaitCodRef     (USHORT Axis, double* pData);
	WINUSERAPI BOOL WINAPI IKStopCodRef     (USHORT Axis);

	WINUSERAPI BOOL WINAPI IKClear	        (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKStatus         (USHORT Axis, ULONG* pStatus);

	WINUSERAPI BOOL WINAPI IKRead32         (USHORT Axis, USHORT Latch, LONG*   pData);
	WINUSERAPI BOOL WINAPI IKRead48         (USHORT Axis, USHORT Latch, double* pData);

	WINUSERAPI BOOL WINAPI IKReadPhase      (USHORT Axis, BYTE* pData);
	WINUSERAPI BOOL WINAPI IKWritePhase     (USHORT Axis, BYTE   Data);
	WINUSERAPI BOOL WINAPI IKLoadPhase      (USHORT Axis, BYTE* pData);

	WINUSERAPI BOOL WINAPI IKReadAmp        (USHORT Axis, BYTE* pData);
	WINUSERAPI BOOL WINAPI IKWriteAmp       (USHORT Axis, BYTE   Data);
	WINUSERAPI BOOL WINAPI IKLoadAmp        (USHORT Axis, BYTE* pData);

	WINUSERAPI BOOL WINAPI IKReadOffset     (USHORT Axis, SHORT* Ofs0, SHORT* Ofs90);
	WINUSERAPI BOOL WINAPI IKWriteOffset    (USHORT Axis, SHORT  Ofs0, SHORT  Ofs90);
	WINUSERAPI BOOL WINAPI IKLoadOffset	    (USHORT Axis, SHORT* Ofs0, SHORT* Ofs90);

	WINUSERAPI BOOL WINAPI IKStore	 	    (USHORT Axis);
	WINUSERAPI BOOL WINAPI IKDefault		(USHORT Axis);

	WINUSERAPI BOOL WINAPI IKRomRead        (USHORT Card, BYTE  Adr, BYTE* Data);
	WINUSERAPI BOOL WINAPI IKRomWrite	    (USHORT Card, BYTE  Adr, BYTE  Data);


	WINUSERAPI BOOL WINAPI IKInputW	        (USHORT Axis, USHORT Adr, USHORT* pBuffer);
	WINUSERAPI BOOL WINAPI IKInputL	        (USHORT Axis, USHORT Adr, ULONG*  pBuffer);
	WINUSERAPI BOOL WINAPI IKOutput	        (USHORT Axis, USHORT Adr, USHORT  Data);

	WINUSERAPI BOOL WINAPI IKSetI2C		    (USHORT Card, BOOL SCL, BOOL SDA);
#ifdef __cplusplus
}
#endif

