program sample6;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Axis 1 in Period Mode                                 }
{                                                       }
{ V 1.00                                                }
{ July 1994                                             }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

uses crt,ik121_0,ik121_1;

var
  board                   : ik121_pointr;
  axis1,axis2           : g26_pointr;
  reg,a,b                 : word;
  ende                    : boolean;
  eing                    : char;
  longi                   : longint;
(*________________________________________*)
procedure main;
begin
  clrscr;

  (* Axis 1 *)
  write_g26(board^.axis[1]^.baseadr,1,30,$0000);
  write_g26(board^.axis[1]^.baseadr,1,28,$0008);
  write_g26(board^.axis[1]^.baseadr,1,18,$0000);
  write_g26(board^.axis[1]^.baseadr,1,14,$0000);
  write_g26(board^.axis[1]^.baseadr,1,12,$0300);
  (* Axis 2 *)
  write_g26(board^.axis[2]^.baseadr,2,30,$0000);
  write_g26(board^.axis[2]^.baseadr,2,28,$0008);
  write_g26(board^.axis[2]^.baseadr,2,18,$0000);
  write_g26(board^.axis[2]^.baseadr,2,14,$0000);
  write_g26(board^.axis[2]^.baseadr,2,12,$0300);

  textcolor(15);
  writeln(' Periode Mode');
  writeln;
  writeln(' Start counter                         ->Press a ');
  writeln(' Reset counter                         ->Press b ');
  writeln(' Stop counter                          ->Press c ');
  writeln(' Software latch in register 1          ->Press d ');
  writeln(' Special software latch in register 1  ->Press e ');
  writeln(' Start with ref                        ->Press h ');
  writeln(' Start and reset with ref              ->Press i ');
  writeln(' Stop with ref                         ->Press j ');
  writeln;
  writeln(' Quit                                  ->Press q ');
  textcolor(4);

  ende:=false;
  repeat
    eing:=#32;

    (* Software latch *)
    write_g26(board^.axis[1]^.baseadr,1,14,$0001);
    write_g26(axis2^.baseadr,2,14,$0001);

    (* Read status bit for "latched" and read data register *)

    a:=read_g26(board^.axis[1]^.baseadr,1,14);
    if (a and $0001=$0001) then
      begin
        a:=read_g26(board^.axis[1]^.baseadr,1,0);
        b:=read_g26(board^.axis[1]^.baseadr,1,2);
        a:=a and $FFC0;
        longi:=b;
        longi:=longi shl 16;
        longi:=longi + a;
        if (b and $8000)=$8000 then
          begin
            longi:=longi shr 10;
            longi:=longi or $FFC00000;
          end
        else
          begin
            longi:=longi shr 10;
          end;
        gotoxy(1,21);
        write(' Axis 1 - Reg 0:  ',longi,'       ');
      end;
    a:=read_g26(board^.axis[1]^.baseadr,1,14);
    if (a and $0002=$0002) then
      begin
        a:=read_g26(board^.axis[1]^.baseadr,1,6);
        b:=read_g26(board^.axis[1]^.baseadr,1,8);
        a:=a and $FFC0;
        longi:=b;
        longi:=longi shl 16;
        longi:=longi + a;
        if (b and $8000)=$8000 then
          begin
            longi:=longi shr 10;
            longi:=longi or $FFC00000;
          end
        else
          begin
            longi:=longi shr 10;
          end;
        gotoxy(1,23);
        write(' Axis 1 - Reg 1:  ',longi,'       ');
      end;

    (* Axis 2 *)
    a:=read_g26(axis2^.baseadr,2,14);
    if (a and $0001=$0001) then
      begin
        a:=read_g26(axis2^.baseadr,2,0);
        b:=read_g26(axis2^.baseadr,2,2);
        a:=a and $FFC0;
        longi:=b;
        longi:=longi shl 16;
        longi:=longi + a;
        if (b and $8000)=$8000 then
          begin
            longi:=longi shr 10;
            longi:=longi or $FFC00000;
          end
        else
          begin
            longi:=longi shr 10;
          end;
        gotoxy(1,22);
        write(' Axis 2 - Reg 0:  ',longi,'       ');
      end;
    a:=read_g26(axis2^.baseadr,2,14);
    if (a and $0002=$0002) then
      begin
        a:=read_g26(axis2^.baseadr,2,6);
        b:=read_g26(axis2^.baseadr,2,8);
        a:=a and $FFC0;
        longi:=b;
        longi:=longi shl 16;
        longi:=longi + a;
        if (b and $8000)=$8000 then
          begin
            longi:=longi shr 10;
            longi:=longi or $FFC00000;
          end
        else
          begin
            longi:=longi shr 10;
          end;
        gotoxy(1,24);
        write(' Axis 2 - Reg 1:  ',longi,'       ');
      end;

    reg:=Read_G26(board^.axis[1]^.baseadr,1,14);
    gotoxy(40,20);
    write('DG90  ');
    if (reg and $4000)=$4000 then write('1') else write('0');
    gotoxy(40,21);
    write('DG00  ');
    if (reg and $2000)=$2000 then write('1') else write('0');
    gotoxy(40,22);
    write('Freq. ');
    if (reg and $0040)=$0400 then write('1') else write('0');

    if keypressed then eing:=readkey;
    case eing of
      'a': begin
             write_g26(board^.axis[1]^.baseadr,1,14,$0008);
             write_g26(axis2^.baseadr,2,14,$0008);
           end;
      'b': begin
             write_g26(board^.axis[1]^.baseadr,1,14,$0020);
             write_g26(axis2^.baseadr,2,14,$0020);
           end;
      'c': begin
             write_g26(board^.axis[1]^.baseadr,1,14,$0010);
             write_g26(axis2^.baseadr,2,14,$0010);
           end;
      'd': begin
             write_g26(board^.axis[1]^.baseadr,1,14,$0002);
             write_g26(axis2^.baseadr,2,14,$0002);
           end;
      'e': begin
             write_g26(board^.axis[1]^.baseadr,1,18,$0040);
             write_g26(axis2^.baseadr,2,18,$0040);
             write_g26(board^.axis[1]^.baseadr,1,14,$0004);
             write_g26(axis2^.baseadr,2,14,$0004);
           end;
      'h': begin
             write_g26(board^.axis[1]^.baseadr,1,16,$0001);
             write_g26(axis2^.baseadr,2,16,$0001);
           end;
      'i': begin
             write_g26(board^.axis[1]^.baseadr,1,16,$0005);
             write_g26(axis2^.baseadr,2,16,$0005);
           end;
      'j': begin
             write_g26(board^.axis[1]^.baseadr,1,16,$0002);
             write_g26(axis2^.baseadr,2,16,$0002);
           end;
      'q': begin
             ende:=true;
           end;
     end;
  until ende;
end;
(*________________________________________*)
begin
  textbackground(7);
  clrscr;
  New(board);
  New(axis1);
  New(axis2);
  board^.axis[1]:=axis1;
  board^.axis[2]:=axis2;
  init_ik121(board);
  if (look_for_ik121(board)) then
    begin
      main
    end
  else
    begin
      clrscr;
      write('No hardware!!');
      readln;
    end;
  Dispose(board);
  Dispose(axis1);
  Dispose(axis2);
  textbackground(0);
  clrscr;
end.
(*________________________________________*)