program sample32;

{-------------------------------------------------------
 DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

 A simple program for the IK 121 to display
 two axes. Measured value with 32 bits.

 V 1.01
 April 1995
 -------------------------------------------------------}

{$N+,E+}
{$V+}
{$R+}

USES crt,ik121_0;
CONST
  base_address = $330;
VAR
  c_value_0, c_value_1  : comp;

BEGIN

clrscr;
   (* Initialise the board in interpolation mode,
   axis 1 *)
write_g26 (base_address, 1, $0c, $0001);
   (* Initialise the board in interpolation mode,
   axis 2 *)
write_g26 (base_address, 2, $0c, $0001);
   (* Reset error bit, start counter, axis 1 *)
write_g26 (base_address, 1, $0e, $0048);
   (* Reset error bit, start counter, axis 2 *)
write_g26 (base_address, 2, $0e, $0048);
   (* Write to control register 2, axis 1 *)
write_g26 (base_address, 1, $1c, $0028);
   (* Write to control register 2, axis 2 *)
write_g26 (base_address, 2, $1c, $0028);

REPEAT
(* Software latch in register 0, axis 1 *)
soft_l0 (base_address, 1);
   (* Software latch in register 0, axis 2 *)
soft_l0 (base_address, 2);
   (* Poll whether latched in axis 1 *)
poll_latch (base_address, 1, 0);
   (* Read axis 1 *)
c_value_0:= read_count_value32 (base_address, 1, 0,false);
   (* Poll whether latched in axis 2 *)
poll_latch (base_address, 2, 0);
   (* Read axis 2 *)
c_value_1:= read_count_value32 (base_address, 2, 0,false);

   (* Display measured values *)
gotoxy(1,10);
write(c_value_0*0.02/1024:16:4,
	c_value_1*0.02/1024:16:4);

UNTIL KEYPRESSED;
END.
