program sample1;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Display of Axes 1 and 2                               }
{                                                       }
{ V 1.00                                                }
{ July 1994                                             }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

uses crt,ik121_0,ik121_1;

var
  board                 : ik121_pointr;
  axis1,axis2           : g26_pointr;
(*________________________________________*)
procedure main;
begin
  (* Axis 1 *)

  axis1^.inimain.mode1024:=false;
  axis1^.inimain.en_48bit:=false;
  axis1^.softcomm.clear:=true;
  axis1^.softcomm.start:=true;

  (* Axis 2 *)

  axis2^.inimain.mode1024:=true;
  axis2^.inimain.en_48bit:=true;
  axis2^.softcomm.clear:=true;
  axis2^.softcomm.start:=true;

  Init_Handler(axis1);
  Init_Handler(axis2);
  Comm_Handler(axis1);
  Comm_Handler(axis2);

  gotoxy(1,20);
  writeln(' Press any key!');
  repeat
    (* Latch with software command *)
      Soft_latch0(axis1);
      Soft_latch0(axis2);
    (* Poll on status bit *)
      Poll_Reg0(axis1);
      Poll_Reg0(axis2);
    (* Display value *)
      gotoxy(1,10);
      textcolor(4);
      writeln(' Axis1 - Reg0:  ',axis1^.register0:12:0,'       ');
      textcolor(1);
      writeln(' Axis2 - Reg0:  ',axis2^.register0:12:0,'       ');
  until keypressed;
end;
(*________________________________________*)
begin
  textbackground(7);
  clrscr;
  textcolor(15);
  New(board);
  New(axis1);
  New(axis2);
  board^.axis[1]:=axis1;
  board^.axis[2]:=axis2;
  init_ik121(board);
  if (look_for_ik121(board)) then
    begin
      main
    end
  else
    begin
      clrscr;
      write('No hardware!!');;
      readln;
    end;
  Dispose(board);
  Dispose(axis1);
  Dispose(axis2);
  textbackground(0);
  clrscr;
end.
(*________________________________________*)