{-------------------------------------------------------------------------}
{ Dr JOHANNES HEIDENHAIN, Traunreut, West Germany                         }
{                                                                         }
{ Demonstration program to illustrate the programming of the interface    }
{ card IK120 using the unit IK120.PAS.                                    }
{                                                                         }
{ Writing $FF to address $60 of the interface card generates a strobe.    }
{ Interval counter is set to generate a latch signal when a strobe occurs.}
{ This freezes the counts of both axes simultaneously.                    }
{ Counts are read sequentialy with the Read_Count routine.                }
{ Read_Count does not latch the axes as in Soft_Count.                    }
{-------------------------------------------------------------------------}

program FREEZE2;

uses IK120, crt;

var
   Period      : real;
   SubDivision : integer;
   s,sz:string;

Procedure SetupCounters;
{------------------------------------------------------------}
{ Standard sequence for initialising counters                }
{------------------------------------------------------------}
begin
    Init_Interface(0);
    Init_Interface(1);
    Interpolation(0,m_interpol);
    Interpolation(1,m_interpol);
    Init_Counter (0,reset_start,fourfold,normal,linear);
    Init_Counter (1,reset_start,fourfold,normal,linear);
    Reset_uas(0);
    Reset_uas(1);
    Reset_Status(0);
    Reset_Status(1);
end;

BEGIN
    Clrscr;
    Writeln('FREEZE2 - Simultaneous Latching of Both Axes of IK 120');
    Writeln('');
    Period := 0.010;   { Grating period in mm }
    Subdivision := 200;
    m_interpol:=I_50;

    SetupCounters;
    {------------------------------------------------------------}
    { Set Interval counter to latch counters when a software     }
    { STROBE ($FF written to Base Address + $60 ) occurs.        }
    {------------------------------------------------------------}
    Latch_Enable(0,Internal);
    Latch_Enable(0,LatchOut);
    Init_Latch(0,Strobe_Latch,fourfold,0);
    delay(1);

    repeat
       Write_Strobe(0);            { Latchs both axes simultaneously       }
                                   { Counters can then be read sequentialy }

       Read_Count(0,0,Count);      { Reads storage register 1 }
       gotoxy(10,10);
       write( Period * Count/Subdivision :8:4);

       Read_Count(1,0,Count);      { Reads storage register 1 }
       gotoxy(10,12);
       write( Period * Count/Subdivision :8:4);

    until keypressed;
END.
