(*************************************************************************)
(* Dr JOHANNES HEIDENHAIN, Traunreut, West Germany                       *)
(*                                                                       *)
(* Demonstration program to illustrate the programming of the interface  *)
(* card IK120 using the IK120.PAS unit supplied.                         *)
(*                                                                       *)
(* Illustates the use of Soft_Count                                      *)
(* Signal checking is included in this program                           *)
(*************************************************************************)

program DEMO2;

uses IK120, crt,BigDisp;

var
   Period:       real;
   SubDivision : integer;
   s,sz:         string;
   lastval :     array [0..1] of string;

procedure Display_count( axis,x,y: integer);
var Count:longint;
    Status: byte;
    Val:real;
begin
   Count := 0;
   Status := 0;
   Soft_Count(axis,Status,Count);
   Val:= Period*Count/Subdivision;
   Ldisplay(Val, Rounded,x,y,8,4,false,Signal_error(axis),lastval[axis]);
end;

(********************* main program ***********************)
BEGIN
    clrscr;
    Writeln('DEMO2 - Demo Program for IK 120');
    Writeln('');
    Period := 0.010;   { Grating period in mm }
    Subdivision := 200;
    m_interpol:=I_50;
    Init_Interface(0);
    Init_Interface(1);
    Interpolation(0,m_interpol);
    Interpolation(1,m_interpol);
    Init_Counter (0,reset_start,fourfold,normal,linear);
    Init_Counter (1,reset_start,fourfold,normal,linear);
    Reset_uas(0);
    Reset_uas(1);
    Reset_Status(0);
    Reset_Status(1);

    lastval[0]:='XXXXXXXXXX';
    lastval[1]:='XXXXXXXXXX';

    repeat
       Display_count(0,10,10);
       Display_count(1,10,18);
    until keypressed;
END.
