/*----------------------SAMPLE48.C----------------------

 DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

 A simple program for the IK 410.
 Measured value with 48 bits.

 V 1.00
 October 1997

 Project files:        IK410_0.C, SAMPLE48.C
 Include files:        IK410_0.H
 ------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include "ik410_0.h"

#define base_address 0x0340

int main()
{
double c_value_0;

cls;
   /* Initialise the board in interpolation mode */
write_g26 (base_address, 0x0c, 0x0041);
   /* Reset error bit, start counter */
write_g26 (base_address, 0x0e, 0x0048);
   /* Write to control register 2 */
write_g26 (base_address, 0x1c, 0x0028);
   /* Switch to encoder position signals */
write_g26 (base_address, 0x24, 0x0000);

   /* Cursor off */
_setcursortype (_NOCURSOR);

while(!kbhit())
	{
	   /* Software latch in register 0 */
	soft_l0 (base_address);
	   /* Poll whether latched */
	poll_latch (base_address, 0);
	   /* Read Position value */
	c_value_0 = read_count_value48
			    (base_address, 0);


	/* Display measured values */
	printf("\r\t%16.4f",c_value_0*0.02/1024);
	}
getch();
   /* Cursor on */
_setcursortype (_NORMALCURSOR);

return (0);
}


