/*----------------------IK410_0.C-----------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Driver Unit for IK410 (Basic Functions)

  V 1.00
  October 1997
 ------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include "ik410_0.h"

#define _PC_CARD

/*----------------------Functions----------------------*/
/*------------------------------------------------------
			write_g26
 -------------------------------------------------------
 This function writes a value to the IK 410.

 This is a hardware-specific code. Write your own code
 for this function for access to the addresses of
 the hardware in which you have implemented the IK 410.

 -------------------------Parameters--------------------
 baseadr   basic port address
 address   address A0 to A5 of the IK 410
 datum	   value to write to the address
 ------------------------------------------------------*/
void write_g26 (unsigned int baseadr,
               unsigned int address, unsigned int datum)
{


#ifdef _PC_CARD


unsigned int         adr_reg, adr_point, adr_gate;
   /* Discard the last four bits of the card
   address */
baseadr = baseadr & 0x0FF0;
   /* Address B0 to B4 of the counter */
address = address & 0x1F;

/* Load address pointer into address register */
   /* Adress of the address register */
adr_reg = baseadr | 0x0008;
   /* Value of the address register R0 to R2 =
   address of the counter without B0 and B1 */
adr_point = address >> 2;
   /* Load address register */
outpw (adr_reg, adr_point);

	/* Calculate port address */
adr_gate = baseadr | (address & 0x03);

   /* Write <datum> to the counter */
outpw (adr_gate, datum);


#else

	
   /* Write <datum> to the counter */
outpw (baseadr | address, datum);


#endif


}

/*------------------------------------------------------
		       read_g26
 -------------------------------------------------------
 This function reads a value from the IK 410.

 This is a hardware-specific code. Write your own code
 for this function for access to the addresses of
 the hardware in which you have implemented the IK 410.

 -----------------------Parameters---------------------
 baseadr   basic port address
 address   address A0 to A5 of the IK 410
 ------------------------------------------------------*/
unsigned int read_g26 (unsigned int baseadr,
		       unsigned int address)
{


#ifdef _PC_CARD


unsigned int adr_reg, adr_point, adr_gate;
   /* Discard the last four bits of the card
   address */
baseadr = baseadr & 0x0FF0;
   /* Address B0 to B4 of the counter */
address = address & 0x1F;

/* Load address pointer into address register */
   /* Address of the address register */
adr_reg = baseadr | 0x0008;
   /* Value of the address register R0 to R2 =
   address of the counter without B0 and B1 */
adr_point = address >> 2;
   /* Load address register */
outpw (adr_reg, adr_point);

	/* Calculate port address */
adr_gate = baseadr | (address & 0x03);

	/* Read datum from the counter */
return(inpw(adr_gate));


#else


   /* Read datum from the counter */
return(inpw(baseadr | address));


#endif


}
/*------------------------------------------------------
			 soft_l0
 -------------------------------------------------------
 This function reads the measured value and stores
 it in data register 0.
 ------------------------------------------------------*/
void soft_l0 (unsigned int baseadr)
{
write_g26 (baseadr, 0x0e, 0x01);
}


/*------------------------------------------------------
                         soft_l1
 -------------------------------------------------------
 This function reads the measured value and stores
 it in data register 1.
 -----------------------------------------------------*/
void soft_l1 (unsigned int baseadr)
{
write_g26 (baseadr, 0x0e, 0x02);
}

/*------------------------------------------------------
                    read_count_value48
 -------------------------------------------------------
 This function reads 48 bits of a measured value.
 ------------------------------------------------------*/
double read_count_value48 (unsigned int baseadr,
			   unsigned char reg)
{
unsigned int field[3];
double count_value48;

switch (reg)
       {
       case 0:
       field[0] = read_g26 (baseadr, 0);
       field[1] = read_g26 (baseadr, 2);
       field[2] = read_g26 (baseadr, 4);
       break;
       case 1:
       field[0] = read_g26 (baseadr, 6);
       field[1] = read_g26 (baseadr, 8);
       field[2] = read_g26 (baseadr, 10);
       break;
       }

if (field[2] & 0x8000)
		 count_value48 = (double)((field[0]-65535L) +
		 65536.0*(field[1]-65535L)+
		 4294967296.0*(field[2]-65535L)-1);
		 else
		 count_value48 = (double)(field[0] +
		 65536.0*field[1] +
		 4294967296.0*field[2]);


return (count_value48);
}
/*------------------------------------------------------
                    read_count_value32
 -------------------------------------------------------
 This function reads 32 bits of a measured value.
 ------------------------------------------------------*/
long read_count_value32 (unsigned int baseadr,
			 unsigned char reg)
{
union 	mapper
        {
        long field0;
        unsigned int field1[2];
        }buffer;

switch (reg)
       {
       case 0:
       buffer.field1[0] = read_g26 (baseadr, 0);
       buffer.field1[1] = read_g26 (baseadr, 2);
       break;
       case 1:
       buffer.field1[0] = read_g26 (baseadr, 6);
       buffer.field1[1] = read_g26 (baseadr, 8);
       break;
       }
return (buffer.field0);
}


/*------------------------------------------------------
                         latched
 -------------------------------------------------------
 This function checks whether a measured value is
 latched in data register 0 or 1.
 ------------------------------------------------------*/

unsigned char latched (unsigned int baseadr,
		       unsigned char reg)
{
unsigned char result;
switch (reg)
       {
       case 0:
       result = (unsigned char)
		(read_g26 (baseadr, 14) & 0x01);
       break;
       case 1:
       result = (unsigned char)
		(read_g26 (baseadr, 14) & 0x02);
       break;
       }
return (result);
}


/*------------------------------------------------------
                       poll_latch
 -------------------------------------------------------
 This function polls until a measured value is
 latched in data register 0 or 1.
 ------------------------------------------------------*/

void poll_latch (unsigned int baseadr,
		 unsigned char reg)
{
switch (reg)
       {
       case 0:
       while (latched (baseadr, 0) == 0)
       ;
       break;

       case 1:
       while (latched (baseadr, 1) == 0)
       ;
       break;
       }
}

