/*---------------------------IK342_0.H--------------------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Header File for the Basic Functions of the IK342

  V 1.00
  November 1998
  ------------------------------------------------------------------*/


#define CLS printf("\x1B[2J")


/*--------------------------------------------------------------------
  Defines for register addresses.
  ------------------------------------------------------------------*/
#define INITIALIZING_REGISTER   0x24
#define CONTROL_REGISTER_1      0x20
#define CONTROL_REGISTER_2      0x04

//Configuration- and Id-Register
#define ENLATCHX1	 	 				0x00					 
#define ENLATCHX2	 	 				0x02					 
#define ENLATCHX3	 	 				0x04					 
#define ENLATCHX4	 	 				0x06					 
#define LATCHPOL		 				0x08					 
#define MSINPUT		 	 			0x0A					 
#define LATCHSTAT		 				0x0C
#define INTREG		 	 				0x0E


/*--------------------------------------------------------------------
  Macro to calculate the IK address.
  ------------------------------------------------------------------*/
#define CALCULATE_IK_BASE_ADDRESS(switch) \
 ((unsigned short)(switch >> 1)*0x0200) | 0x8000

/*--------------------------------------------------------------------
  Macro to switch VME to A16 memory space.
  ROTEC specific code.
  ------------------------------------------------------------------*/
#define SWITCH_VME_TO_A16_ADDRESS_SPACE(switch)    \
 outport (ADR_REG,\
 ((((unsigned short)(switch >> 1)*0x0200)\
 & 0x8000) >> 8) | 0xFC00)


/*Definitions of functions*/

void WriteRegister (unsigned short, unsigned char,
		 unsigned short, unsigned short);

unsigned short ReadRegister (unsigned short, unsigned char,
			unsigned short);

void SoftLatch_0 (unsigned short, unsigned char);

void SoftLatch_1 (unsigned short, unsigned char);

unsigned char CountValueLatched (unsigned short, unsigned char,
			unsigned char);

void PollForLatched (unsigned short,unsigned char,
			unsigned char);

long ReadCountValue_32 (unsigned short, unsigned char,
			 unsigned char);

double ReadCountValue_48 (unsigned short, unsigned char,
			 unsigned char);

unsigned char ReadConfReg (unsigned short usBaseAddress,
						   unsigned short usRegisterAddress);

void WriteConfReg (unsigned short usBaseAddress, unsigned short usRegisterAddress,
				   unsigned char usDatum);
