/*---------------------------SAMPLE32.C-------------------------------

 DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

 A simple program for the IK 341 to display
 four axes. Measured value with 32 bits.

 V 1.00
 January 1996

 Project files:        IK341_0.C, SAMPLE32.C, VMEINIT.C
 Include files:        IK341_0.H, SAMPLE.H, VMEROTEC.H
 -------------------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include "ik341_0.h"
#include "sample.h"
#include "vmerotec.h"

int main()
{
double dCountValue1, dCountValue2, dCountValue3, dCountValue4;
unsigned short usBaseAddress;

CLS;

  /*Initialize VME interface (ROTEC specific functions)*/
VmeInit();
gotoxy(1, 20);
puts("VMEbus initialized. Press any key!");
getch();
CLS;

usBaseAddress = CALCULATE_IK_BASE_ADDRESS(DIP_SWITCH);
SWITCH_VME_TO_A16_ADDRESS_SPACE(DIP_SWITCH);

   /* Initialise the board in interpolation mode,
   axis 1 */
WriteRegister (usBaseAddress, 1, INITIALIZING_REGISTER, 0x0001);
   /* Initialise the board in interpolation mode,
   axis 2 */
WriteRegister (usBaseAddress, 2, INITIALIZING_REGISTER, 0x0001);
   /* Initialise the board in interpolation mode,
   axis 3 */
WriteRegister (usBaseAddress, 3, INITIALIZING_REGISTER, 0x0001);
   /* Initialise the board in interpolation mode,
   axis 4 */
WriteRegister (usBaseAddress, 4, INITIALIZING_REGISTER, 0x0001);

   /* Reset error bit, start counter, axis 1 */
WriteRegister (usBaseAddress, 1, CONTROL_REGISTER_1, 0x0048);
   /* Reset error bit, start counter, axis 2 */
WriteRegister (usBaseAddress, 2, CONTROL_REGISTER_1, 0x0048);
   /* Reset error bit, start counter, axis 3 */
WriteRegister (usBaseAddress, 3, CONTROL_REGISTER_1, 0x0048);
   /* Reset error bit, start counter, axis 4 */
WriteRegister (usBaseAddress, 4, CONTROL_REGISTER_1, 0x0048);

   /* Write to control register 2, axis 1 */
WriteRegister (usBaseAddress, 1, CONTROL_REGISTER_2, 0x0008);
   /* Write to control register 2, axis 2 */
WriteRegister (usBaseAddress, 2, CONTROL_REGISTER_2, 0x0008);
   /* Write to control register 2, axis 3 */
WriteRegister (usBaseAddress, 3, CONTROL_REGISTER_2, 0x0008);
   /* Write to control register 2, axis 4 */
WriteRegister (usBaseAddress, 4, CONTROL_REGISTER_2, 0x0008);

   /*Cursor off*/
_setcursortype(_NOCURSOR);

while(!kbhit())
	{
           /* Software latch in register 0, axis 1 */
	SoftLatch_0 (usBaseAddress, 1);
           /* Software latch in register 0, axis 2 */
	SoftLatch_0 (usBaseAddress, 2);
           /* Software latch in register 0, axis 3 */
	SoftLatch_0 (usBaseAddress, 3);
           /* Software latch in register 0, axis 4 */
	SoftLatch_0 (usBaseAddress, 4);

           /* Poll whether latched in axis 1 */
	PollForLatched (usBaseAddress, 1, 0);
	   /* Read axis 1 */
	dCountValue1 = (double)ReadCountValue_32 (usBaseAddress, 1, 0);
           /* Poll whether latched in axis 2 */
	PollForLatched (usBaseAddress, 2, 0);
	   /* Read axis 2 */
	dCountValue2 = (double)ReadCountValue_32 (usBaseAddress, 2, 0);
           /* Poll whether latched in axis 3 */
	PollForLatched (usBaseAddress, 3, 0);
	   /* Read axis 3 */
	dCountValue3 = (double)ReadCountValue_32 (usBaseAddress, 3, 0);
           /* Poll whether latched in axis 4 */
	PollForLatched (usBaseAddress, 4, 0);
	   /* Read axis 4 */
	dCountValue4 = (double)ReadCountValue_32 (usBaseAddress, 4, 0);

        /* Display measured values */
  gotoxy(5,5);
	printf("%16.4f\t%16.4f", dCountValue1*0.02/1024,
                           dCountValue2*0.02/1024);
  gotoxy(5,10);
	printf("%16.4f\t%16.4f", dCountValue3*0.02/1024,
	                         dCountValue4*0.02/1024);
	}

   /*Cursor on*/
_setcursortype (_NORMALCURSOR);

return (0);
}


