unit ik121_unit3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls,
  ik121_baseunit, Buttons;

type
  TController = class(TForm)
    Label1: TLabel;
    axis: TPanel;
    cntrl_ok: TBitBtn;
    cntrl_start: TButton;
    cntrl_stopp: TButton;
    cntrl_clr: TButton;
    cntrl_preset: TButton;
    Label3: TLabel;
    cntrl_set: TEdit;
    cntrl_dim0_pan: TPanel;
    cntrl_dim1_pan: TPanel;
    cntrl_dim2_pan: TPanel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    cntrl_dim3_pan: TPanel;
    cntrl_ref: TButton;
    BitBtn1: TBitBtn;
    cntrl_clrdim: TButton;

    procedure axisClick(Sender: TObject);
    procedure cntrl_okClick(Sender: TObject);
    procedure cntrl_startClick(Sender: TObject);
    procedure cntrl_stoppClick(Sender: TObject);
    procedure cntrl_clrClick(Sender: TObject);
    procedure cntrl_dim0_panClick(Sender: TObject);
    procedure cntrl_dim1_panClick(Sender: TObject);
    procedure cntrl_dim2_panClick(Sender: TObject);
    procedure cntrl_dim3_panClick(Sender: TObject);
    procedure cntrl_setChange(Sender: TObject);
    procedure cntrl_presetClick(Sender: TObject);
    procedure cntrl_refClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure cntrl_clrdimClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);

    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

procedure rebuild_cntrl(count:count_pointr);

var
  Controller: TController;
implementation

uses ik121_unit2;
                
{$R *.DFM}

(*************************************************)
(*************************************************)
 procedure rebuild_cntrl(count:count_pointr);
 var
  s     : string;
  x,d   : byte;
  r     : real;

 begin

   x:=count^.axis;

   (* Axis-Display *)
   str(x,s);
   controller.axis.caption:=s;

   if count^.count[x]^.dimension=0 then
     begin
       controller.cntrl_dim0_pan.caption:='X';
       controller.cntrl_dim1_pan.caption:='';
       controller.cntrl_dim2_pan.caption:='';
       controller.cntrl_dim3_pan.caption:='';
     end;
   if count^.count[x]^.dimension=1 then
     begin
       controller.cntrl_dim0_pan.caption:='';
       controller.cntrl_dim1_pan.caption:='X';
       controller.cntrl_dim2_pan.caption:='';
       controller.cntrl_dim3_pan.caption:='';
     end;
   if count^.count[x]^.dimension=2 then
     begin
       controller.cntrl_dim0_pan.caption:='';
       controller.cntrl_dim1_pan.caption:='';
       controller.cntrl_dim2_pan.caption:='X';
       controller.cntrl_dim3_pan.caption:='';
     end;
    if count^.count[x]^.dimension=3 then
     begin
       controller.cntrl_dim0_pan.caption:='';
       controller.cntrl_dim1_pan.caption:='';
       controller.cntrl_dim2_pan.caption:='';
       controller.cntrl_dim3_pan.caption:='X';
     end;

    r:=count^.count[x]^.preval;
    d:=count^.count[x]^.digits;
    str(r:5:d,s);
    controller.cntrl_set.text:=s;

 end;
(*************************************************)
(*************************************************)
procedure TController.FormActivate(Sender: TObject);
begin
  rebuild_cntrl(count);
end;
(*************************************************)
(*************************************************)
procedure TController.axisClick(Sender: TObject);
begin
  count^.axis:=count^.axis+1;
  if count^.axis>count^.axisnumber then
    begin
      count^.axis:=0;
    end;
  rebuild_cntrl(count);
end;
(*************************************************)
(*************************************************)
procedure TController.cntrl_okClick(Sender: TObject);
begin
    controller.Hide;
end;
(*************************************************)
(*************************************************)
procedure TController.cntrl_startClick(Sender: TObject);
var
  x : byte;
begin
   x:=count^.axis;
   Status:=IKStart(x);
end;
(*************************************************)
(*************************************************)
procedure TController.cntrl_stoppClick(Sender: TObject);
var
  x : byte;
begin
   x:=count^.axis;
   Status:=IKStop(x);
end;
(*************************************************)
(*************************************************)
procedure TController.cntrl_clrClick(Sender: TObject);
var
  x,dim : byte;
begin
   x:=count^.axis;
   dim:=count^.count[x]^.dimension;
   count^.count[x]^.dimoffset[dim]:=-count^.count[x]^.rwert;
end;
(*************************************************)
(*************************************************)
procedure TController.cntrl_dim0_panClick(Sender: TObject);
var
  x : byte;
begin
    controller.cntrl_dim0_pan.caption:='X';
    controller.cntrl_dim1_pan.caption:='';
    controller.cntrl_dim2_pan.caption:='';
    controller.cntrl_dim3_pan.caption:='';
    x:=count^.axis;
    count^.count[x]^.dimension:=0;
end;
(*************************************************)
(*************************************************)
procedure TController.cntrl_dim1_panClick(Sender: TObject);
var
  x : byte;
begin
    controller.cntrl_dim0_pan.caption:='';
    controller.cntrl_dim1_pan.caption:='X';
    controller.cntrl_dim2_pan.caption:='';
    controller.cntrl_dim3_pan.caption:='';
    x:=count^.axis;
    count^.count[x]^.dimension:=1;
end;
(*************************************************)
(*************************************************)
procedure TController.cntrl_dim2_panClick(Sender: TObject);
var
  x : byte;
begin
    controller.cntrl_dim0_pan.caption:='';
    controller.cntrl_dim1_pan.caption:='';
    controller.cntrl_dim2_pan.caption:='X';
    controller.cntrl_dim3_pan.caption:='';
    x:=count^.axis;
    count^.count[x]^.dimension:=2;
end;
(*************************************************)
(*************************************************)
procedure TController.cntrl_dim3_panClick(Sender: TObject);
var
  x : byte;
begin
    controller.cntrl_dim0_pan.caption:='';
    controller.cntrl_dim1_pan.caption:='';
    controller.cntrl_dim2_pan.caption:='';
    controller.cntrl_dim3_pan.caption:='X';
    x:=count^.axis;
    count^.count[x]^.dimension:=3;
end;
(*************************************************)
(*************************************************)
procedure TController.cntrl_setChange(Sender: TObject);
var
  s      : string;
  code   : integer;
  x      : byte;
  r      : real;
begin
    x:=count^.axis;
    s:=controller.cntrl_set.text;
    val(s,r,code);
    count^.count[x]^.preval:=r;
end;
(*************************************************)
(*************************************************)
procedure TController.cntrl_presetClick(Sender: TObject);
var
  x,dim   : byte;
  r,p,e : real;
begin
   x:=count^.axis;
   dim:=count^.count[x]^.dimension;
   r:=count^.count[x]^.rwert;
   p:=count^.count[x]^.preval;
   if count^.count[x]^.system=rotary then
      begin
        if p>360 then p:=360;
        count^.count[x]^.preval:=360;
        rebuild_cntrl(count);
      end;
   e:=-r+p;
   count^.count[x]^.dimoffset[dim]:=e;
end;
(*************************************************)
(*************************************************)
procedure TController.cntrl_refClick(Sender: TObject);
var
  x : byte;
begin
   x:=count^.axis;
   if (count^.count[x]^.refmark=one) then
     begin
       Status:=IKResetREF(x);
     end;
   if count^.count[x]^.refmark=coded then
     begin
       count^.count[x]^.offset:=0;
       Status:=IKStrtCodRef(x,1,count^.count[x]^.distance);
     end;
end;
(*************************************************)
(*************************************************)
procedure TController.BitBtn1Click(Sender: TObject);
begin
  Controller.hide;
end;
(*************************************************)
(*************************************************)
procedure TController.cntrl_clrdimClick(Sender: TObject);
var
  x : byte;
begin
  x:=count^.axis;
  count^.count[x]^.dimoffset[0]:=0;
  count^.count[x]^.dimoffset[1]:=0;
  count^.count[x]^.dimoffset[2]:=0;
  count^.count[x]^.dimoffset[3]:=0;
end;
(*************************************************)
(*************************************************)
end.


