UNIT ik121_baseunit;

interface
(******************************************************************)
uses
  Windows,
  Display_unit1,
  ik121_correct;
(******************************************************************)
const
  maxaxis        = 3; (* 0..3 axis *)
(******************************************************************)
type

  BytePtr   = ^Byte;
  IntPtr    = ^Integer;
  WordPtr   = ^Word;
  Bool32    = LongInt;
  Bool32Ptr = ^Boolean;
  LongPtr   = ^LongInt;
  Long8	    = array [0..7] of longint;
  Long8Ptr  = ^Long8;
  DoublePtr = ^Double;

  TChar     =  array [0..255] of Char;
  CharPtr   = ^TChar;

(******************************************************************)
var
  Counter       : array[0..maxaxis] of TCounter_X;
  boardadressen : long8;
  adrzeiger     : long8ptr;
  Status        : bool32;
  printfile     : text;
(******************************************************************)
TYPE
   axis_pointr   = ^axis_record;
   axis_record   = record
                     resolution    : word;                (* resolution [um] *)
                     period        : word;                (* period [um] *)
                     digits        : byte;                (* digits *)
                     refmark       : (no,one,coded);
                     distance      : word;                (* refmark distance *)
                     direction     : (normal,inverted);   (* count direction *)
                     system        : (linear,rotary);
                     strichzahl    : word;
                     dimension     : byte;
                     dimoffset     : array[0..3] of real;
                     minmode       : boolean;
                     maxmode       : boolean;
                     minwert       : real;
                     maxwert       : real;
                     minbound      : real;
                     maxbound      : real;
                     min           : boolean;
                     max           : boolean;
                     typ           : boolean;
                     iwert         : longint;             (* true bin. value reg.0 *)
                     sign          : char;                (* counter value*)
                     offset        : real;                (* for coded refmarks *)
                     rwert         : real;
                     awert         : real;                (* display value *)
                     value         : string[255];         (* output string *)
                     preval        : real;
                     status        : longint;
                     refstatus     : char;
                     errorflag     : boolean;
                     errorstring   : string[20];
                     ad00          : word;
                     ad90          : word;
                  end;

   (* Counter Values *)
   count_pointr = ^count_record;
   count_record = record
                    count      : array[0..maxaxis] of axis_pointr;
                    axis       : byte;       (* selected axis number *)
                    axisnumber : byte;       (* total number of axes *)
                  end;

   countstore   = record
                    count      : array[0..maxaxis] of axis_record;
                  end;

   (* Printer Values *)
   print_pointr = ^print_record;
   print_record = record
                    drvname    : char;       (* printer output drive *)
                    dirname    : string[64]; (* printer output directory *)
                    filename   : string[64]; (* printer output file *)
                  end;

   printstore   = record
                    drvname    : char;
                    dirname    : string[64];
                    filename   : string[64];
                  end;

   (* AD-Values *)
   adsample = array[0..N_Values] of word;

(******************************************************************)

   adwert = record
              dg00 : real;
              dg90 : real;
            end;

   adoktant = record
                wert    : array[0..val_in_okt] of adwert;
                index   : byte;
                Rmittel : real;
              end;

   xywerte = array[0..7] of adoktant;

   adkreis  = record
                oktant        : xywerte;
                scount        : word;
                samp_req      : boolean;
                samp_rdy      : boolean;
                of0           : real;
                of9           : real;
              end;

(******************************************************************)
var
  count           : count_pointr;
  cprint          : print_pointr;
  axis            : array[0..maxaxis] of axis_pointr;
(****************************)
  autoadjust      : boolean;
  autosample      : boolean;
(****************************)

  Ellipse_Param   : array[0..maxaxis] of ellpar;
  sin_val,cos_val : adsample;
  ellipse_error   : boolean;
(****************************)
  ik_ad           : array[0..maxaxis] of adkreis;
(****************************)

(******************************************************************)
PROCEDURE new_pointers;
PROCEDURE dispose_pointers;
PROCEDURE Init_counter(count:count_pointr);
PROCEDURE Init_Printer(cprint:print_pointr);
PROCEDURE Init_Correct;
PROCEDURE Write_CSetup(count:count_pointr);
PROCEDURE Read_CSetup(count:count_pointr);
PROCEDURE Write_PSetup(cprint:print_pointr);
PROCEDURE Read_PSetup(cprint:print_pointr);
procedure print_wert(cprint:print_pointr;count:count_pointr);
procedure reset_printer(cprint:print_pointr);
procedure build_wert(axis:axis_pointr);
procedure build_status(axis:axis_pointr);
(******************************************************************)
(* DLL-functions                                                  *)
(******************************************************************)
Function IKFind	(pBuffer8: Long8Ptr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKInit	(Axis: Word; Mode: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKReset	(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKStart	(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKStop	(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKLatch	(Axis: Word; Latch: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKResetREF	(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKStartREF		(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKStopREF		(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKLatchREF	(Axis: Word; Latch: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKLatched		(Axis: Word; Latch: Word; pStatus: Bool32Ptr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKWaitLatch	(Axis: Word; Latch: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKStrtCodRef	(Axis: Word; Latch: Word; RefDist: LongInt) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKCodRef 		(Axis: Word; pStatus: Bool32Ptr; pData: DoublePtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKWaitCodRef 	(Axis: Word; pData: DoublePtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKStopCodRef	(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKClear		(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKStatus	(Axis: Word; pStatus: LongPtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKRead32	(Axis: Word; Latch: Word; pData: LongPtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKRead48	(Axis: Word; Latch: Word; pData: DoublePtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKReadPhase	(Axis: Word; pData: BytePtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKWritePhase	(Axis: Word;   Data: Byte) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKLoadPhase	(Axis: Word; pData: BytePtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKReadAmp	(Axis: Word; pData: BytePtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKWriteAmp	(Axis: Word;   Data: Byte) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKLoadAmp	(Axis: Word; pData: BytePtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKReadOffset	(Axis: Word; Ofs0: IntPtr;   Ofs90: IntPtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKWriteOffset	(Axis: Word; Ofs0: Integer; Ofs90: Integer) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKLoadOffset	(Axis: Word; Ofs0: IntPtr;   Ofs90: IntPtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKStore		(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKDefault	(Axis: Word) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKRomRead	(Card: Word; Adr: Byte; Data: BytePtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKRomWrite	(Card: Word; Adr: Byte; Data: Byte) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKInputW	(Axis: Word; Adr: Word; pData: WordPtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKInputL	(Axis: Word; Adr: Word; pData: LongPtr) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKOutput	(Axis: Word; Adr: Word;   Data: LongInt) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKSetI2C	(Card: Word; SCL: Bool32; SDA: Bool32) : Bool32; StdCall; External 'IK121DLL.DLL';
Function IKVersion      (Axis: Word; pVersCard: CharPtr;pVersDrv: CharPtr; pVersDll: CharPtr) : Bool32; StdCall;  External 'IK121DLL.DLL';
(******************************************************************)
implementation

uses
    ik121_printer;
(******************************************************************)
(*                                                                *)
(******************************************************************)
PROCEDURE new_pointers;
VAR
  x : byte;
BEGIN
  New(count);
  for x:=0 to maxaxis do
    begin
      New(axis[x]);
      count^.count[x]:=axis[x];
    end;
  New(cprint);
END;
(******************************************************************)
PROCEDURE dispose_pointers;
VAR
  x : byte;
BEGIN
  Dispose(count);
  for x:=0 to maxaxis do
    begin
      Dispose(axis[x]);
    end;
  Dispose(cprint);
END;
(******************************************************************)
(* Default values                                                 *)
(******************************************************************)
PROCEDURE Init_wert(axis:axis_pointr);
BEGIN
        axis^.resolution  := 1;
        axis^.period      := 10;
        axis^.digits      := 5;

        axis^.refmark     := no;
        axis^.distance    := 1000;

        axis^.direction   := normal;

        axis^.system      := linear;
        axis^.strichzahl  := 1000;

        axis^.dimension   := 0;
        axis^.dimoffset[0]:= 0;
        axis^.dimoffset[1]:= 0;
        axis^.dimoffset[2]:= 0;
        axis^.dimoffset[3]:= 0;

        axis^.minmode     := false;
        axis^.maxmode     := false;
        axis^.minwert     := -100;
        axis^.maxwert     := +100;

        axis^.minbound    := -100;
        axis^.maxbound    := +100;
        axis^.min         := false;
        axis^.max         := false;
        axis^.typ         := false;

        axis^.iwert       := 0;
        axis^.offset      := 0;
        axis^.rwert       := 0;
        axis^.awert       := 0;
        axis^.sign        := '+';
        axis^.value       := '0.00000';
        axis^.preval      := 100;

        axis^.status      := 0;
        axis^.refstatus   := ' ';
        axis^.errorflag   := false;
        axis^.errorstring := '....................';

        axis^.ad00        := 0;
        axis^.ad90        := 0;
END;
(******************************************************************)
(* Initialize axis with default values                                  *)
(******************************************************************)
PROCEDURE Init_Counter(count:count_pointr);
VAR
  x : byte;
BEGIN
    count^.axis:=0;
    for x:=0 to maxaxis do
      begin
        Init_wert(count^.count[x]);
      end;
END;
(******************************************************************)
(* Initialize axis with default values                                  *)
(******************************************************************)
PROCEDURE Init_Printer(cprint:print_pointr);
BEGIN
    cprint^.drvname:='c';
    cprint^.dirname:='';
    cprint^.filename:='ik121.prt';
END;
(******************************************************************)
(* Initialize axis with default values                                  *)
(******************************************************************)
PROCEDURE Init_Correct;
VAR
  x,i : byte;
BEGIN
    for x:=0 to maxaxis do
      begin
        ik_ad[x].scount:=0;
        for i:=0 to 7 do
          begin
            ik_ad[x].oktant[i].index:=0;
          end;
        ik_ad[x].samp_req := false;
        ik_ad[x].samp_rdy := false;
      end;
END;
(******************************************************************)
(* Save setup in file:  IK121.CNT                                 *)
(******************************************************************)
PROCEDURE Write_CSetup(count:count_pointr);
VAR
  initfile        : file of countstore;
  buffer          : countstore;
  x               : byte;
BEGIN
  AssignFile(initfile,'IK121.CNT');
  {$I-}
  Rewrite(initfile);
  {$I+}
  if ioresult=0 then
    begin
      for x:=0 to maxaxis do
        begin
          buffer.count[x]:=count^.count[x]^;
        end;
      write(initfile,buffer);
      CloseFile(initfile);
    end;
END;
(******************************************************************)
(* Save setup in file:  IK121.PNT                                 *)
(******************************************************************)
PROCEDURE Write_PSetup(cprint:print_pointr);
VAR
  initfile        : file of printstore;
  buffer          : printstore;
BEGIN
  AssignFile(initfile,'IK121.PNT');
  {$I-}
  Rewrite(initfile);
  {$I+}
  if ioresult=0 then
    begin
      buffer.drvname  := cprint^.drvname;
      buffer.dirname  := cprint^.dirname;
      buffer.filename := cprint^.filename;
      write(initfile,buffer);
      CloseFile(initfile);
    end;
END;
(******************************************************************)
(* Load setup                                                     *)
(******************************************************************)
PROCEDURE Read_CSetup(count:count_pointr);
VAR
  x                 : byte;
  initfile          : file of countstore;
  buffer            : countstore;
  nofile            : Boolean;
BEGIN
  init_counter(count);
  nofile:=true;
  AssignFile(initfile,'IK121.CNT');
  {$I-}
  Reset(initfile);
  {$I+}
  if ioresult=0 then
    begin
      {$I-}
      read(initfile,buffer);
      {$I+}
      if ioresult=0 then
        begin
          for x:=0 to maxaxis do
            begin
              (* not all parameters are stored !! *)
              count^.count[x]^.resolution  :=buffer.count[x].resolution;
              count^.count[x]^.period      :=buffer.count[x].period;
              count^.count[x]^.digits      :=buffer.count[x].digits;
              count^.count[x]^.refmark     :=buffer.count[x].refmark;
              count^.count[x]^.direction   :=buffer.count[x].direction;
              count^.count[x]^.system      :=buffer.count[x].system;
              count^.count[x]^.distance    :=buffer.count[x].distance;
              count^.count[x]^.strichzahl  :=buffer.count[x].strichzahl;
              count^.count[x]^.dimension   :=buffer.count[x].dimension;
              count^.count[x]^.dimoffset[0]:=buffer.count[x].dimoffset[0];
              count^.count[x]^.dimoffset[1]:=buffer.count[x].dimoffset[1];
              count^.count[x]^.dimoffset[2]:=buffer.count[x].dimoffset[2];
              count^.count[x]^.dimoffset[3]:=buffer.count[x].dimoffset[3];
              count^.count[x]^.minmode     :=buffer.count[x].minmode;
              count^.count[x]^.maxmode     :=buffer.count[x].maxmode;
              count^.count[x]^.minwert     :=buffer.count[x].minwert;
              count^.count[x]^.maxwert     :=buffer.count[x].maxwert;
              count^.count[x]^.minbound    :=buffer.count[x].minbound;
              count^.count[x]^.maxbound    :=buffer.count[x].maxbound;
            end;
          nofile:=false;
        end;
      CloseFile(initfile);
    end;
  if nofile then
    begin
      write_csetup(count);
    end;
END;
(******************************************************************)
(* Load setup                                                     *)
(******************************************************************)
PROCEDURE Read_PSetup(cprint:print_pointr);
VAR
  initfile          : file of printstore;
  buffer            : printstore;
  nofile            : boolean;
BEGIN
  init_printer(cprint);
  nofile:=true;
  AssignFile(initfile,'IK121.PNT');
  {$I-}
  Reset(initfile);
  {$I+}
  if ioresult=0 then
    begin
      {$I-}
      read(initfile,buffer);
      {$I+}
      if ioresult=0 then
        begin
          cprint^.drvname  := buffer.drvname;
          cprint^.dirname  := buffer.dirname;
          cprint^.filename := buffer.filename;
          nofile:=false;
        end;
      CloseFile(initfile);
    end;
  if nofile then
    begin
      write_psetup(cprint);
    end;
END;
(******************************************************************)
(******************************************************************)
procedure print_xy(count:count_pointr);
var
  x : byte;
  s : string;
begin
  for x:=0 to count^.axisnumber do
    begin
     str(x,s);
     writeln(printfile,'Axis'+s+' : ',count^.count[x]^.sign,count^.count[x]^.value);
    end;
  writeln(printfile);
end;
(******************************************************************)
(******************************************************************)
procedure print_wert(cprint:print_pointr;count:count_pointr);
begin
  AssignFile(printfile,cprint^.filename);
  {$I-}
  Append(printfile);             (* when file exists *)
  {$I+}
  if ioresult=0 then
    begin
      print_xy(count);
      CloseFile(printfile);
    end
  else
    begin
      {$I-}
      Rewrite(printfile);        (* if new file *)
      {$I+}
      if ioresult=0 then
        begin
          print_xy(count);
          CloseFile(printfile);
        end
      else
        begin
          output.printer_error.caption:='ERROR';
        end;
    end;
end;
(******************************************************************)
(******************************************************************)
procedure reset_printer(cprint:print_pointr);
begin
  AssignFile(printfile,cprint^.filename);
  {$I-}
  Rewrite(printfile);
  {$I+}
  if ioresult=0 then
    begin
      CloseFile(printfile);
    end
  else
    begin
      output.printer_error.caption:='ERROR';
    end;
end;
(******************************************************************)
(******************************************************************)
procedure Build_wert(axis:axis_pointr);
var
   a,b,dim    : byte;
   wert,offset,
   zwert,
   period,
   resolution : real;
   strich     : word;
   value      : string;
   sign       : boolean;
BEGIN

  wert:=axis^.iwert;

 (* Offset for coded refmarks *)
  offset:=axis^.offset;
  wert:=wert+offset;

  (* Rotary mode *)
  if axis^.system=rotary then
    begin
       (* convert to 0-360 *)
       strich:=axis^.strichzahl;
       wert:=wert*360/(strich*1024);
    end
  else
    begin
      (* Count value to [um] *)
      period:=axis^.period;  (* default: 10 um *)
      wert:=wert*period/1024;

      (* Resolution *)
      resolution:=axis^.resolution;
      wert:=wert*1000;     (* um -> nm *)
      wert:=wert/resolution;
      wert:=int(wert);
      wert:=wert*resolution;
      wert:=wert/1000000;  (* nm -> mm *)
    end;

  (* Store calculated values *)
  axis^.rwert:=wert;

  (* Add dimension offset *)
  dim:=axis^.dimension;
  wert:=wert+axis^.dimoffset[dim];

  (* Rotary mode 0-360*)
  if axis^.system=rotary then
    begin
       (* Modulo 360 *)
       if wert>=0 then
         begin
           zwert:=int(wert/360);
           wert:=wert-(zwert*360);
         end
       else
         begin
           wert:=abs(wert);
           zwert:=int(wert/360);
           wert:=360-(wert-(zwert*360));
         end;
       (* Direction *)
       if axis^.direction=inverted then
        begin
          wert:=360-wert;
        end;
    end
  else
    begin
      if axis^.direction=inverted then
        begin
          wert:=-wert;
        end;
    end;

  (* Sorting *)
  if wert>axis^.maxbound then
    begin
      axis^.max:=true;
    end
  else
    begin
      axis^.max:=false;
    end;

  if wert<axis^.minbound then
    begin
      axis^.min:=true;
    end
  else
    begin
      axis^.min:=false;
    end;

   if (wert>=axis^.minbound) and
      (wert<=axis^.maxbound) then
    begin
      axis^.typ:=true;
    end
  else
    begin
      axis^.typ:=false;
    end;

  (* Min Mode *)
  if axis^.minmode then
    begin
      if wert<axis^.minwert then
        begin
          axis^.minwert:=wert;
        end
      else
        begin
          wert:=axis^.minwert;
        end;
    end;
  (* Max Mode *)
  if axis^.maxmode then
    begin
      if wert>axis^.maxwert then
        begin
          axis^.maxwert:=wert;
        end
      else
        begin
          wert:=axis^.maxwert;
        end;
    end;

  (* Store output value *)
  axis^.awert:=wert;

  (* Get algebraic sign *)
  sign:=true;
  if wert<0 then
    begin
      wert:=abs(wert);
      sign:=false;
    end;

  (* Integers *)
  a:=14-axis^.digits;
  (* Dec. places *)
  b:=axis^.digits;

  (* convert string *)
  str(wert:a:b,value);

  (* Sign *)
  if sign then
    begin
      axis^.sign:='+';
    end
  else
    begin
      axis^.sign:='-';
    end;

  (* Output value *)
  axis^.value:=value;

END;
(******************************************************************)
(******************************************************************)
procedure build_status(axis:axis_pointr);
var
  data : longint;
begin

  data:=axis^.status;
  (* Encoder signal error*)
  if (data and $60000) = $60000 then
    begin
      if not(axis^.errorflag) then
        begin
          axis^.errorstring:='Signal-Error........';
          axis^.errorflag:=true;
        end;
    end
  else
    begin
      if axis^.errorflag then
        begin
          axis^.errorstring:='....................';
          axis^.errorflag:=false;
        end;
    end;
     (* Ref. mark command active *)
  if (data and $100) = $100 then
    begin
      axis^.refstatus:='X';
    end
  else
    begin
      axis^.refstatus:=' ';
    end;

end;
(******************************************************************)
(******************************************************************)
end.
