unit logo;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ HEIDENHAIN Trademark                                  }
{                                                       }
{ V 1.00                                                }
{ July 1994                                             }
{-------------------------------------------------------}


interface

procedure jh_logo;

implementation

uses crt,graph;
(*________________________________________*)
procedure d_sign(x,y,size:word);
begin
  moveto(x,y);
  lineto(x-(size*10),y-(size)*17);
  lineto(x+(size*10),y-(size)*17);
  lineto(x,y);
end;
(*________________________________________*)
procedure i_sign(x,y,size:word);
begin
  moveto(x,y);
  lineto(x-(size*15),y-(size)*8);
end;
(*________________________________________*)
procedure a_sign(x,y,size:word);
begin
  moveto(x,y);
  lineto(x-(size*10),y-(size)*17);
  lineto(x+(size*10),y-(size)*17);
end;
(*________________________________________*)
procedure u_sign(x,y,size:word);
begin
  moveto(x,y);
  lineto(x-(size*20),y);
  moveto(x-(size*9),y-(size)*16);
  lineto(x,y);
end;
(*________________________________________*)
procedure r_sign(x,y,size:word);
begin
  moveto(x,y);
  lineto(x-(size*20),y);
  lineto(x-(size*9),y-(size)*16);
  lineto(x-(size*4),y-(size)*7);
end;
(*________________________________________*)
procedure jh_logo;
var
  graphmode,graphdriver : integer;
  xmax,ymax             : word;
begin
  clrscr;
  graphdriver:=detect;
  initgraph(graphdriver,graphmode,'');
  setbkcolor(7);
  settextstyle(0,0,2);
  setcolor(8);
  outtextxy(20,420,'    DR. JOHANNES HEIDENHAIN GmbH');
  setcolor(15);
  outtextxy(22,422,'    DR. JOHANNES HEIDENHAIN GmbH');
  settextstyle(0,0,3);
  setcolor(8);
  outtextxy(220,20,'IK 121');
  setcolor(15);
  outtextxy(222,22,'IK 121');

  setcolor(15);
  rectangle(1,1,getmaxx-1,getmaxy-1);

  setcolor(8);
  setfillstyle(1,8);
  bar(100,50,500,400);
  setcolor(15);
  moveto(102,398);
  lineto(102,52);
  lineto(498,52);
  setcolor(7);
  lineto(498,398);
  lineto(102,398);

  setcolor(15);
  circle(300,225,150);
  moveto(170,300);
  lineto(430,300);

  d_sign(255,300,2);
  i_sign(280,258,2);
  a_sign(283,246,2);
  d_sign(310,205,2);
  u_sign(335,158,2);
  r_sign(360,117,2);

end;
(*________________________________________*)
end.