/*----------------------------RDROM.CPP--------------------------------------

  DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany

  Basic Functions for reading the EEPROM 

  V 1.00
  April 1996
 ---------------------------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <fstream.h>
#include "Ik121.h"
#include "Ik121_1.h"


/****************************************************************************/
/**		Globals                                                           **/
/****************************************************************************/
extern unsigned char iic_error;



const unsigned short Adr_Ik121[] =
{
0,
(DIP_SWITCH_CARD1	& 0x003f) <<4,
(DIP_SWITCH_CARD2 & 0x003f) <<4,
(DIP_SWITCH_CARD3	& 0x003f) <<4,
(DIP_SWITCH_CARD4 & 0x003f) <<4,
(DIP_SWITCH_CARD5 & 0x003f) <<4,
(DIP_SWITCH_CARD6 & 0x003f) <<4,
(DIP_SWITCH_CARD7 & 0x003f) <<4,
(DIP_SWITCH_CARD8 & 0x003f) <<4,
(DIP_SWITCH_CARD9 & 0x003f) <<4,
(DIP_SWITCH_CARD10 & 0x003f) <<4,
(DIP_SWITCH_CARD11 & 0x003f) <<4,
(DIP_SWITCH_CARD12 & 0x003f) <<4,
(DIP_SWITCH_CARD13 & 0x003f) <<4,
(DIP_SWITCH_CARD14 & 0x003f) <<4,
(DIP_SWITCH_CARD15 & 0x003f) <<4,
(DIP_SWITCH_CARD16 & 0x003f) <<4
};

unsigned short Card_Adr;

/*--------------------------------------------------------------------
									 Main
 --------------------------------------------------------------------- */

int main()
{
pCard board;
board = new struct cardc;
for(int i=1;i<=16;i++)
	{
	if(Adr_Ik121[i] != 0x000)
		{
		board->card[i] = new struct ik121;
		board->card[i]->axis[1] = new struct g26;
		board->card[i]->axis[2] = new struct g26;
		Card_Adr = Adr_Ik121[i];
		InitIk121(board->card[i]);
		if (!LookforIk121(board->card[i]))
			{
			cout << "\n Ik121 number" << i  << " is missing";
			exit(-1);
			}
		}
	}

	cout << "\n\t Reading from Ik121 EEPROM";
	cout << "\n\t -------------------------";
	cout << "\n";
	unsigned char c;
	unsigned short adr = 0;
	for(adr=0; adr<512; adr++)
		{
		c = RomRead(board->card[1],adr);
		printf("%c",c);
		}
	
for(int j=1;j<=16;j++)
	{
	if(Adr_Ik121[j] != 0x000)
		{
		delete board->card[j]->axis[1];
		delete board->card[j]->axis[2];
		delete board->card[j];
		}
	 }
delete board;			 		  
return (0);
}

