(*************************************************************************)
(* Dr JOHANNES HEIDENHAIN, Traunreut, West Germany                       *)
(* 31.03.92                                                              *)
(*                                                                       *)
(* Demonstration program to illustrate the programming of the interface  *)
(* card IK110/IK120 without using the driver software.                   *)
(* Use this example to program the IK 110/120 in other languages.        *)
(*************************************************************************)
Program TstIK;

Uses Crt;
const
     IK         = $C800;
     Ctrl1      = $20;          { Control register 1 }
     Ctrl2      = $30;          { Control register 2 }
     { Counter registers }
     InitReg    = $0F;          { Initialising }
     RefReg     = $0A;          { Reference mark command register }
     ComReg     = $0B;          { Counter command register, start/stop/reset }
     OpModeReg  = $0C;          { Count mode register 1/2/4 fold, direction }
     StatReg    = $0D;          { Status register }
     DataReg0   = $00;          { 4 byte counter value }
     DataReg1   = $04;          { 4 byte counter value }
     LReg0      = $08;          { Latch to store counter value in DataReg0 }
     LReg1      = $09;          { Lacth to store counter value in DataReg1 }
     Period     = 0.010;        { Signal period of measuring probe 10um }
     Subdivision= 200;          { Number of counts per signal period (10um) }

Procedure InitIK110(axis:byte);
var dummy: Byte;
begin
     mem[IK:Ctrl1]:=$0F;          { Interp. 50 fach, Reset Freq. error }
     mem[IK:Ctrl1]:=$03;          { Reset  }
     mem[IK:Ctrl1]:=$0F;          { Interp. 50 fach, Reset Freq. error }
     mem[IK:Ctrl2]:=$00;          { Reset Control Register 2 }

     mem[IK: axis+InitReg]:=$00;  {  50 fold, Initialising register    }
     mem[IK: axis+StatReg]:=$FF;  {  Delete status bits       }
     mem[IK: axis+OpModeReg]:=$03;{  4-fold , normal direction, linear  }
     mem[IK: axis+RefReg]:=$00;   {  Reference mark inactive     }
     mem[IK: axis+ComReg]:=$05;   {  Reset and start counter  }
     dummy:=mem[IK: axis+$3];     {  Enable data register 0   }
     dummy:=mem[IK: axis+$7];     {  Enable data register 1   }
end;

function GetData(axis:byte): longint;
begin
     mem[IK:axis+LReg0]:= $FF;
     GetData:= meml[IK: axis+DataReg0];
end;

begin
     ClrScr;
     Writeln('Test Program for IK 110/120');
     InitIK110($00);       { Address of first counter }
     InitIK110($10);       { Address of 2nd counter   }
     repeat
           Gotoxy( 10,10 );
           Write( Getdata($00) * Period/Subdivision:8:3,
                  Getdata($10) * Period/Subdivision:9:3 );
     until keypressed;
end.