{-------------------------------------------------------------------------}
{ Dr JOHANNES HEIDENHAIN, Traunreut, West Germany                         }
{                                                                         }
{ Demonstration program to illustrate the programming of the interface    }
{ card IK120 using the unit IK120.PAS.                                    }
{                                                                         }
{ A hardware interrupt is generated when an external latch signal is      }
{ detected at pin 1 or 2 on input X3.                                     }
{ Interrupt programming in this way allows the PC to carry out other      }
{ tasks.                                                                  }
{ As soon as the latch is detected the PC interrupts what it is doing.    }
{ The interrupt service routine is then carried out.                      }
{ This routine should read the measuring values and include the CLEAR_INT }
{ reset the interrupt controller.                                         }
{                                                                         }
{                        *** IMPORTANT ***                                }
{                                                                         }
{ The interrupt jumper must be set to IRQ5 for EXTERNAL INTERRUPTS.       }
{ The external latch will not generate an interrupt signal if the jumper  }
{ is set for an internal interrupt IRQ5.                                  }
{                                                                         }
{-------------------------------------------------------------------------}

program INTERUPT;

uses IK120, crt, dos;

const Int5Vec = $0D;     { Interrupt address for IRQ5 }
var
   Period: real;
   SubDivision : integer;
   s,sz:string;
   OldIntVec: Pointer;
   count: array [0..1] of longint;


Procedure SetupCounters;
{------------------------------------------------------------}
{ Standard sequence for initialising counters                }
{------------------------------------------------------------}
begin
    Init_Interface(0);
    Init_Interface(1);
    Interpolation(0,m_interpol);
    Interpolation(1,m_interpol);
    Init_Counter (0,reset_start,fourfold,normal,linear);
    Init_Counter (1,reset_start,fourfold,normal,linear);
    Reset_uas(0);
    Reset_uas(1);
    Reset_Status(0);
    Reset_Status(1);
end;



Procedure IntRoutine; Interrupt;
{------------------------------------------------------------------------}
{ The user can program the actions that should occur when an external    }
{ interrupt occurs into this routine.                                    }
{ Keep actions simple avoiding disk accesses etc.                        }
{------------------------------------------------------------------------}

begin
     Read_Count(0,1,Count[0]);
     Read_Count(1,1,Count[1]);
     writeln('Axis 0 = ',period*count[0]/subdivision:8:4,'    ',
             'Axis 1 = ',period*count[1]/subdivision:8:4);
     delay(100);       { Delay to allow time for external switch to reset }

     Clear_Int(0);     { Should allways be the last line of the interrupt }
                       { service routine. Resets the interrupt controller.}
end;



BEGIN
    Clrscr;
    Writeln('INTERUPT - External latching of IK 120 using input X3');
    Writeln('');
    Period := 0.010;   { Grating period in mm }
    Subdivision := 200;
    m_interpol:=I_50;

    SetupCounters;
    Clear_Int(0);
    GetIntVec(Int5Vec,OldIntVec);
    SetIntVec(Int5Vec, @IntRoutine);
    Interrupt_Enable(0,Int_1);

    {-----------------------------------------------------------------}
    { Enable external latch signal.                                   }
    { Data is latched to storage register 0 and not 1 as usualy used. }
    {-----------------------------------------------------------------}
    Latch_Disable(0,Internal);
    Latch_Enable(0,ExternalX1X2);
    writeln('Waiting for an external latch signal to generate an interrupt ...');
    repeat
          { The computer can be programmed to carry out other functions }
          { whilst waiting  for the interrupt to occur. }
    until keypressed;

    SetIntVec(Int5Vec,OldIntVec);
    Clear_Int(0);
END.
