{------------------------------------------------------------------------}
{ Dr JOHANNES HEIDENHAIN, Traunreut, West Germany                        }
{                                                                        }
{ Demonstration program to illustrate the programming of the interface   }
{ card IK120 using the IK120.PAS unit supplied.                          }
{                                                                        }
{ Shows how to evaluate DISTANCE CODED REFERENCE MARKS using the routine }
{ DistanceCodedREFMarks in IK120 unit.                                   }
{------------------------------------------------------------------------}

program CREFMARK;


uses IK120,BigDisp,crt;


const REFSpacing = 1000;    { No. of period between REF marks 0-2,2-4,.. }

var
   Period: real;
   SubDivision,i : integer;
   s,sz:string;
   REFPresets: array[0..1] of longint;
   Lastval: array[0..1] of string;



procedure Display_count( axis,x,y: integer);
{------------------------------------------------------------------------}
{ Latches, reads and displays values from an axis                        }
{------------------------------------------------------------------------}

var Count:longint;
begin
   Count := 0;
   Soft_Count(axis,1,Count);

   LDisplay( (Count/Subdivision + RefPresets[axis]) *Period,Large,x,y,8,4,
             false,Signal_error(axis),Lastval[axis]);
end;



Procedure SetUpCounters;
{------------------------------------------------------------------------}
{ Standard setup procedure to initialise the counters                    }
{------------------------------------------------------------------------}
var i: integer;
begin
    Period := 0.020;   { Grating period in mm }
    Subdivision := 200;
    m_interpol:=I_50;
    for i:= 0 to 1 do
    begin
         RefPresets[i] := 0;
         LastVal[i]:='XXXXXXXXXX';
         Init_Interface(i);
         Interpolation(i,m_interpol);
         Init_Counter (i,reset_start,fourfold,normal,linear);
         Reset_uas(i);
         Reset_Status(i);
    end;
end;


{------------------------------------------------------------------------}

BEGIN
    clrscr;
    Writeln('CREFMARK - Demo Program for IK 120');
    Writeln('');

    SetUpCounters;

    { Traverse REF marks }
    for i:= 0 to 0 do
    begin
        Gotoxy(1,6+i); ClrEol;
        write('Traverse distance-coded REF marks in Axis ',i,' ...');
        REFPresets[i]:=DistanceCodedREFMarks(i,REFSpacing,SubDivision,
                                         Fourfold,normal,linear);
    end;

    repeat
       Display_count(0,10,10);
       Display_count(1,10,18);
    until keypressed;
END.
