{------------------------------------------------------------------------}
{ Dr JOHANNES HEIDENHAIN, Traunreut, West Germany                        }
{ Demonstration program to illustrate the programming of the interface   }
{ card IK120 using the IK120.PAS unit supplied.                          }
{                                                                        }
{ Demonstrates the use of the unit BIGDISP to display values with large  }
{ characters.                                                            }
{ Shows how to use more than one interface card in one PC.               }
{ Addresses must set card 1 = $C800, card 2 = $C840,...                  }
{------------------------------------------------------------------------}

program BIGDEMO;

uses IK120,BIGDISP, crt;

Const
     Axes = 4;

var
   Period      : real;
   SubDivision : integer;
   i,status: byte;
   L_string: array [0..Axes] of string;
   count: longint;


(********************* main program ***********************)
BEGIN
    clrscr;
    Period := 0.010;   { Grating period in mm }
    Subdivision := 200;
    m_interpol:=I_50;
    Count := 0;
    Status := 0;

    { Setup each axis }
    for i:= 0 to Axes-1 do
    begin
      Init_Interface(i);
      Interpolation(i,m_interpol);
      Init_Counter (i,reset_start,fourfold,normal,linear);
      Reset_uas(i);
      Reset_Status(i);
      L_string[i] := 'XXXXXXXXXX';
    end;

    Gotoxy(25,3); write('BIGDEMO DEMO PROGRAM FOR IK 120');
    Gotoxy(60, 5); write('MEDIUM DISPLAY');
    Gotoxy(60,10); write('MEDIUM, MIN:SEC');
    Gotoxy(60,15); write('LARGE DISPLAY');
    Gotoxy(60,20); write('ROUNDED DISPLAY');

    { Latch and display values }
    repeat
         i:=0;
         Soft_Count(i,Status,Count);
         LDisplay(Period * Count/Subdivision,Medium,24 ,
                     i*5+5 ,8,4,false,false,L_string[i]);
         i:=1;
         Soft_Count(i,Status,Count);
         LDisplay(Period * Count/Subdivision,Medium,16 ,
                     i*5+4 ,8,4,true,false,L_string[i]);
         i:=2;
         Soft_Count(i,Status,Count);
         LDisplay(Period * Count/Subdivision,Large,3,
                     i*5+4 ,8,4,false,false,L_string[i]);
         i:=3;
         Soft_Count(i,Status,Count);
         LDisplay(Period * Count/Subdivision,Rounded,3,
                     i*5+4 ,8,4,false,false,L_string[i]);
    until keypressed;
    ClrScr;
END.
