program sample3;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{                                                       }
{ V 1.00                                                }
{ Nov 1995                                              }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

uses crt,dos,ik120_0,ik120_1;

var
  board       : ik120_pointr;
  axis1,axis2 : g6_pointr;
  buffer      : char;
(*________________________________________*)
procedure abruf0;
begin
  clrscr;
  textcolor(15);
  board^.axis[1]^.inilatch.en_latch0:=false;
  board^.axis[1]^.inilatch.en_latch1:=true;
  board^.axis[1]^.softcomm.start:=true;
  board^.axis[1]^.softcomm.clear:=true;
  board^.axis[1]^.softcomm.clrerror:=true;
  Init_G6Handler(board^.axis[1]);
  Comm_G6Handler(board^.axis[1]);
  board^.axis[2]^.inilatch.en_latch0:=false;
  board^.axis[2]^.inilatch.en_latch1:=true;
  board^.axis[2]^.softcomm.start:=true;
  board^.axis[2]^.softcomm.clear:=true;
  board^.axis[2]^.softcomm.clrerror:=true;
  Init_G6Handler(board^.axis[2]);
  Comm_G6Handler(board^.axis[2]);
  gotoxy(1,1);
  writeln('Latch Register1 with common Software-Strobe');
  gotoxy(40,20);
  writeln('Press any key!');
  textcolor(4);
  repeat
      Soft_strobe(board);
      Read_Reg1(axis1);
      Read_Reg1(axis2);
      gotoxy(1,10);
      textcolor(4);
      writeln(' Axis1 - Reg1:  ',axis1^.register1:12:0,'       ');
      textcolor(1);
      writeln(' Axis2 - Reg1:  ',axis2^.register1:12:0,'       ');
  until keypressed;
  buffer:=readkey;
end;
(*________________________________________*)
procedure abruf1;
begin
  clrscr;
  textcolor(15);
  board^.axis[1]^.inilatch.en_latch0:=true;
  board^.axis[1]^.inilatch.en_latch1:=false;
  board^.axis[1]^.softcomm.start:=true;
  board^.axis[1]^.softcomm.clear:=true;
  board^.axis[1]^.softcomm.clrerror:=true;
  Init_G6Handler(board^.axis[1]);
  Comm_G6Handler(board^.axis[1]);
  board^.axis[2]^.inilatch.en_latch0:=true;
  board^.axis[2]^.inilatch.en_latch1:=false;
  board^.axis[2]^.softcomm.start:=true;
  board^.axis[2]^.softcomm.clear:=true;
  board^.axis[2]^.softcomm.clrerror:=true;
  Init_G6Handler(board^.axis[2]);
  Comm_G6Handler(board^.axis[2]);
  gotoxy(1,1);
  writeln('Latch Register0 with common Software-Strobe');
  gotoxy(40,20);
  writeln('Press any key!');
  textcolor(4);
  repeat
      Soft_strobe(board);
      Read_Reg0(axis1);
      Read_Reg0(axis2);
      gotoxy(1,10);
      textcolor(4);
      writeln(' Axis1 - Reg0:  ',axis1^.register0:12:0,'       ');
      textcolor(1);
      writeln(' Axis2 - Reg0:  ',axis2^.register0:12:0,'       ');
  until keypressed;
  buffer:=readkey;
end;
(*________________________________________*)
procedure abruf2;
begin
  clrscr;
  textcolor(15);
  board^.axis[1]^.inilatch.en_latch0:=false;
  board^.axis[1]^.inilatch.en_latch1:=true;
  board^.axis[1]^.softcomm.start:=true;
  board^.axis[1]^.softcomm.clear:=true;
  board^.axis[1]^.softcomm.clrerror:=true;
  Init_G6Handler(board^.axis[1]);
  Comm_G6Handler(board^.axis[1]);
  board^.axis[2]^.inilatch.en_latch0:=false;
  board^.axis[2]^.inilatch.en_latch1:=true;
  board^.axis[2]^.softcomm.start:=true;
  board^.axis[2]^.softcomm.clear:=true;
  board^.axis[2]^.softcomm.clrerror:=true;
  Init_G6Handler(board^.axis[2]);
  Comm_G6Handler(board^.axis[2]);
  board^.inilatch.en_l1_ext1:=true;
  board^.inilatch.en_l1_ext2:=true;
  Init_IKHandler(board);
  gotoxy(1,1);
  writeln('Latch Register1: Axis 1  ext. button 1 - Axis 2 ext. button 2');
  gotoxy(40,20);
  writeln('Press any key!');
  textcolor(4);
  repeat
      Read_Reg1(axis1);
      Read_Reg1(axis2);
      gotoxy(1,10);
      textcolor(4);
      writeln(' Axis1 - Reg1:  ',axis1^.register1:12:0,'       ');
      textcolor(1);
      writeln(' Axis2 - Reg1:  ',axis2^.register1:12:0,'       ');
  until keypressed;
  buffer:=readkey;
end;
(*________________________________________*)
procedure abruf3;
begin
  clrscr;
  textcolor(15);
  board^.axis[1]^.inilatch.en_latch0:=false;
  board^.axis[1]^.inilatch.en_latch1:=true;
  board^.axis[1]^.softcomm.start:=true;
  board^.axis[1]^.softcomm.clear:=true;
  board^.axis[1]^.softcomm.clrerror:=true;
  Init_G6Handler(board^.axis[1]);
  Comm_G6Handler(board^.axis[1]);
  board^.axis[2]^.inilatch.en_latch0:=false;
  board^.axis[2]^.inilatch.en_latch1:=true;
  board^.axis[2]^.softcomm.start:=true;
  board^.axis[2]^.softcomm.clear:=true;
  board^.axis[2]^.softcomm.clrerror:=true;
  Init_G6Handler(board^.axis[2]);
  Comm_G6Handler(board^.axis[2]);
  board^.inilatchcnt.counter:=nop;
  board^.inilatch.en_l0:=false;
  board^.inilatch.en_l1_ext1:=false;
  board^.inilatch.en_l1_ext2:=false;
  board^.inisync.en_ausgang:=true;
  Init_IKHandler(board);
  gotoxy(1,1);
  writeln('Latch both axis with Strobe from ext. button 1 or button 2');
  gotoxy(40,20);
  writeln('Press any key!');
  textcolor(4);
  repeat
      Read_Reg1(axis1);
      Read_Reg1(axis2);
      gotoxy(1,10);
      textcolor(4);
      writeln(' Axis1 - Reg1:  ',axis1^.register1:12:0,'       ');
      textcolor(1);
      writeln(' Axis2 - Reg1:  ',axis2^.register1:12:0,'       ');
  until keypressed;
  buffer:=readkey;
end;
(*________________________________________*)
procedure abruf4;
begin
  clrscr;
  textcolor(15);
  board^.axis[1]^.inilatch.en_latch0:=true;
  board^.axis[1]^.inilatch.en_latch1:=false;
  board^.axis[1]^.softcomm.start:=true;
  board^.axis[1]^.softcomm.clear:=true;
  board^.axis[1]^.softcomm.clrerror:=true;
  Init_G6Handler(board^.axis[1]);
  Comm_G6Handler(board^.axis[1]);
  board^.axis[2]^.inilatch.en_latch0:=true;
  board^.axis[2]^.inilatch.en_latch1:=false;
  board^.axis[2]^.softcomm.start:=true;
  board^.axis[2]^.softcomm.clear:=true;
  board^.axis[2]^.softcomm.clrerror:=true;
  Init_G6Handler(board^.axis[2]);
  Comm_G6Handler(board^.axis[2]);

  board^.inilatch.en_l0:=true;
  board^.inilatch.en_l1_ext1:=false;
  board^.inilatch.en_l1_ext2:=false;
  board^.inisync.en_ausgang:=true;

  board^.inilatchcnt.value:=999;
  Init_IKHandler(board);
  board^.inilatchcnt.counter:=clear;
  Init_IKHandler(board);
  board^.inilatchcnt.counter:=start;
  Init_IKHandler(board);

  gotoxy(1,1);
  writeln('Latch both axis Reg 0 with Strobe from Latch-Counter');
  gotoxy(40,20);
  writeln('Press any key!');
  textcolor(4);
  repeat

      Soft_latch1(axis1);
      Soft_latch1(axis2);
      Read_Reg1(axis1);
      Read_Reg1(axis2);

      Read_Reg0(axis1);
      Read_Reg0(axis2);

      gotoxy(1,10);
      textcolor(4);
      writeln(' Axis1 - Reg0:  ',axis1^.register0:12:0,'       ');
      textcolor(1);
      writeln(' Axis2 - Reg0:  ',axis2^.register0:12:0,'       ');
      writeln;
      textcolor(4);
      writeln(' Axis1 - Reg1:  ',axis1^.register1:12:0,'       ');
      textcolor(1);
      writeln(' Axis2 - Reg1:  ',axis2^.register1:12:0,'       ');
  until keypressed;
  buffer:=readkey;
end;
(*________________________________________*)
procedure abruf5;
begin
  clrscr;
  textcolor(15);
  board^.axis[1]^.inilatch.en_latch0:=true;
  board^.axis[1]^.inilatch.en_latch1:=false;
  board^.axis[1]^.softcomm.stop:=true;
  board^.axis[1]^.softcomm.clear:=true;
  board^.axis[1]^.softcomm.clrerror:=true;
  Init_G6Handler(board^.axis[1]);
  Comm_G6Handler(board^.axis[1]);
  board^.axis[2]^.inilatch.en_latch0:=true;
  board^.axis[2]^.inilatch.en_latch1:=false;
  board^.axis[2]^.softcomm.stop:=true;
  board^.axis[2]^.softcomm.clear:=true;
  board^.axis[2]^.softcomm.clrerror:=true;
  Init_G6Handler(board^.axis[2]);
  Comm_G6Handler(board^.axis[2]);

  board^.inilatch.en_l0:=true;
  board^.inilatch.en_l1_ext1:=false;
  board^.inilatch.en_l1_ext2:=false;
  board^.inisync.en_ausgang:=true;

  board^.inilatchcnt.value:=999;
  Init_IKHandler(board);
  board^.inilatchcnt.counter:=clear;
  Init_IKHandler(board);
  board^.inilatchcnt.counter:=stop;
  Init_IKHandler(board);

  board^.axis[1]^.refcomm.ristart:=true;
  Comm_G6Handler(board^.axis[1]);
  board^.axis[2]^.refcomm.ristart:=true;
  Comm_G6Handler(board^.axis[2]);
  board^.inilatchcnt.counter:=ristart;
  Init_IKHandler(board);

  gotoxy(1,1);
  writeln('Latch both axis Reg 0 with Strobe from Latch-Counter');
  writeln('and start with ref-mark');
  gotoxy(40,20);
  writeln('Press any key!');
  textcolor(4);
  repeat

      Soft_latch1(axis1);
      Soft_latch1(axis2);
      Read_Reg1(axis1);
      Read_Reg1(axis2);

      Read_Reg0(axis1);
      Read_Reg0(axis2);

      gotoxy(1,10);
      textcolor(4);
      writeln(' Axis1 - Reg0:  ',axis1^.register0:12:0,'       ');
      textcolor(1);
      writeln(' Axis2 - Reg0:  ',axis2^.register0:12:0,'       ');
      writeln;
      textcolor(4);
      writeln(' Axis1 - Reg1:  ',axis1^.register1:12:0,'       ');
      textcolor(1);
      writeln(' Axis2 - Reg1:  ',axis2^.register1:12:0,'       ');
  until keypressed;
  buffer:=readkey;
end;
(*________________________________________*)
begin
  textbackground(7);
  textcolor(15);
  New(board);
  New(axis1);
  New(axis2);
  board^.axis[1]:=axis1;
  board^.axis[2]:=axis2;
  init_ik120(board);
  if look_for_ik120(board) then
    begin
      abruf0;
      abruf1;
      abruf2;
      abruf3;
      abruf4;
      abruf5;
    end
  else
    begin
      clrscr;
      write('No hardware!!');
      readln;
    end;
  Dispose(axis1);
  Dispose(axis2);
  Dispose(board);
  textbackground(0);
  clrscr;
end.