program sample2;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Interrupt Test                                        }
{                                                       }
{ V 1.00                                                }
{ Nov 1995                                              }
{-------------------------------------------------------}
{ IRQ5                                                  }
{ IRQ3                                                  }
{ Interrupt jumpers must be plugged in!                 }
{ The interrupts are triggered by a falling edge        }
{ at the L0 or L1 input                                 }
{-------------------------------------------------------}

{$N+,E+}
{$V+}
{$R+}

uses crt,dos,ik120_0,ik120_1;

var
  board                   : ik120_pointr;
  axis1,axis2             : g6_pointr;
  oldvec1,newvec1,
  oldvec2,newvec2         : pointer;

  int1,int2               : byte;

(*________________________________________*)
(*    Extern                              *)
(*________________________________________*)
procedure hardlatch1;interrupt;
begin
    Dis_Int(int1);
    read_reg1(board^.axis[1]);
    read_reg1(board^.axis[2]);
    gotoxy(1,20);
    textcolor(4);
    writeln(' Axis1 - Register1:  ',board^.axis[1]^.register1:10:0,'       ');
    gotoxy(1,21);
    writeln(' Axis2 - Register1:  ',board^.axis[2]^.register1:10:0,'       ');
    textcolor(15);
    Clear_int;
    En_Int(int1);
end;
(*________________________________________*)
(*    Intern                              *)
(*________________________________________*)
procedure hardlatch2;interrupt;
begin
    Dis_Int(int2);
    read_reg0(board^.axis[2]);
    gotoxy(1,15);
    textcolor(1);
    writeln(' Axis2 - Register0:  ',board^.axis[2]^.register0:10:0,'       ');
    textcolor(15);
    Clear_int;
    En_Int(int2);
end;
(*________________________________________*)
procedure main;
begin
  clrscr;
  writeln('Axis1 Reg0 latched by Software in mainprogram');
  writeln('Axis1 Reg1 latched by ext. Button    -> Interrupt');

  writeln('Axis2 Reg0 latched by Latch-Counter  -> Interrupt');
  writeln('Axis2 Reg1 latched by ext. Button    -> Interrupt');

  (* Axis 1 *)
  board^.axis[1]^.softcomm.clear:=true;
  board^.axis[1]^.softcomm.start:=true;
  board^.axis[1]^.inilatch.en_latch0:=false;    (* Reg1 -> Software *)
  board^.axis[1]^.inilatch.en_latch1:=true;     (* Reg1 -> Ext1 *)
  Init_G6Handler(board^.axis[1]);
  Comm_G6Handler(board^.axis[1]);

  (* Axis 2 *)
  board^.axis[2]^.softcomm.clear:=true;
  board^.axis[2]^.softcomm.start:=true;
  board^.axis[2]^.inilatch.en_latch0:=true;     (* Reg0 -> Latch-Count *)
  board^.axis[2]^.inilatch.en_latch1:=true;     (* Reg1 -> Ext2 *)
  Init_G6Handler(board^.axis[2]);
  Comm_G6Handler(board^.axis[2]);

  board^.inilatchcnt.value:=999;
  board^.inilatch.en_l0:=true;
  board^.inilatch.en_l1_ext1:=true;
  board^.inilatch.en_l1_ext2:=true;
  board^.inisync.en_ausgang:=true;
  Init_IKHandler(board);

  board^.inilatchcnt.counter:=clear;
  Init_IKHandler(board);
  board^.inilatchcnt.counter:=start;
  Init_IKHandler(board);

  getintvec(int1,oldvec1);
  newvec1:=@hardlatch1;
  setintvec(int1,newvec1);

  getintvec(int2,oldvec2);
  newvec2:=@hardlatch2;
  setintvec(int2,newvec2);

  read_reg0(board^.axis[1]);
  read_reg0(board^.axis[2]);
  read_reg1(board^.axis[1]);
  read_reg1(board^.axis[2]);

  board^.iniint.latch_int:=true;
  board^.iniint.latch_ext:=true;
  Init_IKHandler(board);

  En_int(int1);
  En_int(int2);
  Clear_int;

  gotoxy(40,22);
  writeln('Press any key !');
  gotoxy(1,9);
  writeln('Main-Routine : ');
  gotoxy(1,19);
  writeln('Interrupt1-Routine : ');
  gotoxy(1,14);
  writeln('Interrupt1-Routine : ');

  repeat
    Soft_latch0(board^.axis[1]);
    Read_Reg0(board^.axis[1]);
    Dis_Int(int2);
    Dis_Int(int1);
    gotoxy(1,10);
    writeln(' Axis1 - Register0:  ',board^.axis[1]^.register0:10:0,'       ');
    En_Int(int2);
    En_Int(int1);
  until keypressed;

  Dis_Int(int2);
  Dis_Int(int1);
  setintvec(int2,oldvec2);
  setintvec(int1,oldvec1);
end;
(*________________________________________*)
begin
  textbackground(7);
  clrscr;
  textcolor(15);
  New(board);
  New(axis1);
  New(axis2);
  board^.axis[1]:=axis1;
  board^.axis[2]:=axis2;
  init_ik120(board);
  if look_for_ik120(board) then
    begin
      int1:=IRQ5;   (* Extern *)
      int2:=IRQ3;   (* Intern *)
      main
    end
  else
    begin
      clrscr;
      write('No hardware!!');
      readln;
    end;
  Dispose(board);
  Dispose(axis1);
  Dispose(axis2);
  textbackground(0);
  clrscr;
end.
(*________________________________________*)