program sample1;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Display of Axes 1 and 2                               }
{                                                       }
{ V 1.00                                                }
{ Nov 1995                                              }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

uses crt,ik120_0,ik120_1;

var
  board                 : ik120_pointr;
  axis1,axis2           : g6_pointr;
(*________________________________________*)
procedure main;
begin
  (* Axis 1 *)

  axis1^.inimain.interpol:=i25fach;
  axis1^.inimain.flankenaw:=onefold;

  axis1^.softcomm.clear:=true;
  axis1^.softcomm.start:=true;

  (* Axis 2 *)

  axis2^.inimain.interpol:=i50fach;
  axis2^.inimain.flankenaw:=fourfold;

  axis2^.softcomm.clear:=true;
  axis2^.softcomm.start:=true;

  Init_G6Handler(axis1);
  Init_G6Handler(axis2);
  Comm_G6Handler(axis1);
  Comm_G6Handler(axis2);
  Init_IKHandler(board);

  gotoxy(1,20);
  writeln(' Press any key!');
  repeat
    (* Latch with software command *)
      Soft_latch0(axis1);
      Soft_latch0(axis2);
    (* Poll on status bit *)
      Poll_Reg0(axis1);
      Poll_Reg0(axis2);
    (* Display value *)
      gotoxy(1,10);
      textcolor(4);
      writeln(' Axis1 - Reg0:  ',axis1^.register0:12:0,'       ');
      textcolor(1);
      writeln(' Axis2 - Reg0:  ',axis2^.register0:12:0,'       ');
  until keypressed;
end;
(*________________________________________*)
begin
  textbackground(7);
  clrscr;
  textcolor(15);
  New(board);
  New(axis1);
  New(axis2);
  board^.axis[1]:=axis1;
  board^.axis[2]:=axis2;
  init_ik120(board);
  if (look_for_ik120(board)) then
    begin
      main
    end
  else
    begin
      clrscr;
      write('No hardware!!');;
      readln;
    end;
  Dispose(board);
  Dispose(axis1);
  Dispose(axis2);
  textbackground(0);
  clrscr;
end.
(*________________________________________*)