program install;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Program for Installing the IK 120                     }
{                                                       }
{ V 1.00                                                }
{ Nov 1995                                              }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

uses crt,graph,logo,ik120_0,ik120_1,cnt_0;

var
  nr    : byte;
  eing  : char;
  adr   : word;
(*************************************)
function test(adr:word):boolean;
var
  i               : word;
  muster,buffer   : byte;
  free            : boolean;
begin

  (* read *)

  free:=true;
  for i:=0 to $FF do
    begin
      buffer:=mem[adr:i];
      if (buffer<>$FF) then free:=false;
    end;

  (* write and read *)

  if free then
    begin
      muster:=$AA;
      for i:=0 to $FF do
        begin
          mem[adr:i]:=muster;
          muster:=not(muster);
        end;
      for i:=0 to $FF do
        begin
          buffer:=mem[adr:i];
          if (buffer<>$FF) then free:=false;
        end;
    end;
  test:=free;
end;
(*************************************)
procedure adrtest(nr,adr:word;xpos,ypos:byte);
var
  buf1,buf2 : byte;
  w         : string4;
  t         : word;
  a,b,ik    : boolean;
begin
  word_hex(adr,w);
  if test(adr) then
    begin
      gotoxy(xpos,ypos);
      write('Nr:',nr,' Adr.:',w[4],w[3],w[2],w[1],' free')
    end
  else
    begin
      ik:=false;
      a:=true;
      b:=true;

      (* ref-bit programmable *)

      write_G6(adr,1,15,$10);
      write_G6(adr,2,15,$10);
      buf1:=read_g6(adr,1,15);
      buf2:=read_g6(adr,2,15);
      buf1:=buf1 and $10;
      if buf1<>$10 then a:=false;
      buf2:=buf2 and $10;
      if buf2<>$10 then b:=false;

      (* stopp and zero counter *)

      write_G6(adr,1,11,$06);
      write_G6(adr,2,11,$06);
      delay(200);
      buf1:=read_g6(adr,1,14);
      buf2:=read_g6(adr,2,14);
      buf1:=buf1 and $04;
      if buf1<>$00 then a:=false;
      buf2:=buf2 and $04;
      if buf2<>$00 then b:=false;

      buf1:=read_g6(adr,1,0);
      buf2:=read_g6(adr,2,0);
      if buf1<>$00 then a:=false;
      if buf2<>$00 then b:=false;

      (* start counter *)

      write_G6(adr,1,11,$01);
      write_G6(adr,2,11,$01);
      delay(200);
      buf1:=read_g6(adr,1,14);
      buf2:=read_g6(adr,2,14);
      buf1:=buf1 and $04;
      if buf1<>$04 then a:=false;
      buf2:=buf2 and $04;
      if buf2<>$04 then b:=false;

      (* stopp counter *)

      write_G6(adr,1,11,$02);
      write_G6(adr,2,11,$02);
      delay(200);
      buf1:=read_g6(adr,1,14);
      buf2:=read_g6(adr,2,14);
      buf1:=buf1 and $04;
      if buf1<>$00 then a:=false;
      buf2:=buf2 and $04;
      if buf2<>$00 then b:=false;

      ik:=a and b;

      if ik then
        begin
          gotoxy(xpos,ypos);
          write('Nr:',nr,' Adr.:',w[4],w[3],w[2],w[1],' **IK120**');
        end
      else
        begin
          gotoxy(xpos,ypos);
          write('Nr:',nr,' Adr.:',w[4],w[3],w[2],w[1],' not free');
        end;
    end;
end;
(*************************************)
procedure base_address(var number:byte);
begin
  writeln;
  writeln(' Searching for free Memory-space');
  writeln;
  adrtest(1,$C000,2,10);
  adrtest(2,$C400,2,11);
  adrtest(3,$C800,2,12);
  adrtest(4,$CF00,2,13);
  adrtest(5,$D000,2,14);
  adrtest(6,$D400,2,15);
  adrtest(6,$D800,2,16);
  adrtest(6,$DF00,2,16);
  gotoxy(5,5);
  write(' Enter Nr.? ');
  readln(number);
end;
(*************************************)
procedure show_address(number:word;var adr:word);
var
   w      : string4;
   i      : byte;
begin
  case number of
    1 : adr:=$C000;
    2 : adr:=$C400;
    3 : adr:=$C800;
    4 : adr:=$CF00;
    5 : adr:=$D000;
    6 : adr:=$D400;
    7 : adr:=$D800;
    8 : adr:=$DF00;
  end;
  clrscr;
  word_hex(adr,w);
  writeln;
  writeln(' Chosen address:'(*,w[4],w[3],w[2],w[1],'h'*));
  adrtest(number,adr,5,5);
  gotoxy(1,10);
  writeln(' The DIP switch position on your interface card is:');
  writeln;

  if (adr and $2000)=$2000 then
    begin
      gotoxy(1,12);
      writeln('    S1--off');
      gotoxy(30,21);
      write(#178);
    end
  else
    begin
      gotoxy(1,12);
      writeln('    S1--on');
      gotoxy(30,20);
      write(#178);
    end;
  if (adr and $1000)=$1000 then
    begin
      gotoxy(1,13);
      writeln('    S2--off');
      gotoxy(32,21);
      write(#178);
    end
  else
    begin
      gotoxy(1,13);
      writeln('    S2--on');
      gotoxy(32,20);
      write(#178);
    end;
  if (adr and $0800)=$0800 then
    begin
      gotoxy(1,14);
      writeln('    S3--off');
      gotoxy(34,21);
      write(#178);
    end
  else
    begin
      gotoxy(1,14);
      writeln('    S3--on');
      gotoxy(34,20);
      write(#178);
    end;
  if (adr and $0400)=$0400 then
    begin
      gotoxy(1,15);
      writeln('    S4--off');
      gotoxy(36,21);
      write(#178);
    end
  else
    begin
      gotoxy(1,15);
      writeln('    S4--on');
      gotoxy(36,20);
      write(#178);
    end;

  if (adr and $0200)=$0200 then
    begin
      gotoxy(1,16);
      writeln('    S5--off');
      gotoxy(38,21);
      write(#178);
    end
  else
    begin
      gotoxy(1,16);
      writeln('    S5--on');
      gotoxy(38,20);
      write(#178);
    end;

 if (adr and $0100)=$0100 then
    begin
      gotoxy(1,17);
      writeln('    S6--off');
      gotoxy(40,21);
      write(#178);
    end
  else
    begin
      gotoxy(1,17);
      writeln('    S6--on');
      gotoxy(40,20);
      write(#178);
    end;

 if (adr and $0080)=$0080 then
    begin
      gotoxy(1,18);
      writeln('    S7--off');
      gotoxy(42,21);
      write(#178);
    end
  else
    begin
      gotoxy(1,18);
      writeln('    S7--on');
      gotoxy(42,20);
      write(#178);
    end;

 if (adr and $0040)=$0040 then
    begin
      gotoxy(1,19);
      writeln('    S8--off');
      gotoxy(44,21);
      write(#178);
    end
  else
    begin
      gotoxy(1,19);
      writeln('    S8--on');
      gotoxy(44,20);
      write(#178);
    end;

  for i:=28 to 46 do
    begin
      gotoxy(i,19);
      write(#196);
    end;
  for i:=28 to 46 do
    begin
      gotoxy(i,22);
      write(#196);
    end;
  gotoxy(28,19);
  write(#218);
  gotoxy(28,22);
  write(#192);
  gotoxy(46,19);
  write(#191);
  gotoxy(46,22);
  write(#217);
  gotoxy(28,20);
  write(#179);
  gotoxy(28,21);
  write(#179);
  gotoxy(46,20);
  write(#179);
  gotoxy(46,21);
  write(#179);

  gotoxy(28,18);
  write('on');
  gotoxy(28,23);
  write('A17');
  gotoxy(45,23);
  write('A10');
  gotoxy(50,24);
  write('Press Return');
  readln;
end;
(*************************************)
procedure saveadr(adr:word);
begin
  write_adr(adr);
  clrscr;
  gotoxy(1,5);
  writeln(' Chosen address stored in IK120.INI');
  writeln;
  writeln(' Ensure right DIP switch positions!');
  writeln(' Turn power off!');
  writeln(' Put in your interface card');
  writeln(' Run IK120.EXE');
  writeln;
  write(' Press Return');
  readln;
end;
(*************************************)
begin
  jh_logo;
  sound(400);
  delay(300);
  sound(500);
  delay(300);
  sound(600);
  delay(300);
  nosound;
  delay(500);
  closegraph;
  textbackground(7);
  clrscr;
  gotoxy(1,5);
  textcolor(15);
  writeln('  INSTALL IK 120 ');
  writeln;
  writeln('  The IK 120 Interface Card should not be in your PC!');
  writeln;
  write('  Continue (y/n)?');
  repeat
  until keypressed;
  eing:=readkey;
  if (eing='y') or (eing='Y') then
    begin
      clrscr;
      base_address(nr);
      show_address(nr,adr);
      saveadr(adr);
    end;
  textbackground(0);
  clrscr;
end.