#ifndef __UNIMOTOR_H
#define __UNIMOTOR_H

/******************************************************************************
 *
 * File Name:
 *
 *     UniMotor.h
 *
 * Description:
 *
 *     Diese Datei enthlt alle UniMotor Funktionsprototypen.
 *
 * Revision:
 *
 *     02-07-03 : UniMot.dll
 *
 ******************************************************************************/


/****************************************************************
*                                                               *
*                       PciBoardAnzahl                          *
*                                                               *
* Anzahl der UniMotor-Karten in einem PC                        *
*****************************************************************/

extern "C" __declspec(dllexport) int __stdcall PciBoardAnzahl (unsigned int* Anzahl);

/****************************************************************
*                                                               *
*                       PciBoardSelect                          *
*                                                               *
* Auswahl von mehreren UniMotor-Karten in einem PC              *
*****************************************************************/

extern "C" __declspec(dllexport) int __stdcall PciBoardSelect (unsigned int Geraet);

/****************************************************************
*                                                               *
*                       UniMotor-Freigabe                       *
*                                                               *
* Motoransteuerung vom Plx-Controller freigeben                 *
*****************************************************************/

extern "C" __declspec(dllexport) int __stdcall UniMotorFreigabe(void);

/****************************************************************
*                                                               *
*                       GetByte                                 *
*                                                               *
* Funktion zur Eingabe der Bytes von Port A und Port B          *
*****************************************************************/

extern "C" __declspec(dllexport) int __stdcall GetByte(unsigned int Adresse, unsigned int* BitMask);

/****************************************************************
*                                                               *
*                       SetByte                                 *
*                                                               *
* Funktion zur Ausgabe der Bytes von Port C und DA-Wandler-Port *
*****************************************************************/

extern "C" __declspec(dllexport) int __stdcall SetByte(unsigned int Adresse, unsigned int BitMask);

/****************************************************************
*                                                               *
*                       GetFussSchalter                         *
*                                                               *
* Funktion zur Ausgabe des Zustandes des Fussschalters (Lemo)   *
*****************************************************************/

extern "C" __declspec(dllexport) int __stdcall GetFussSchalter(bool* Ein);


/****************************************************************
*                                                               *
*                       SetPumpe                                *
*                                                               *
* Funktion zur Steuerung der Binder Pumpe                       *
*****************************************************************/

extern "C" __declspec(dllexport) int __stdcall SetPumpe(bool Ein);

/****************************************************************
*                                                               *
*                       SetUniMotor                             *
*                                                               *
* Ein- bzw. Ausschalten des Uni-Motors                          *
*****************************************************************/

extern "C" __declspec(dllexport) int __stdcall SetUniMotor(bool Ein);

/****************************************************************
*                                                               *
*                       MoveUp                                  *
*                                                               *
* Funktion zur Steuerung des Motors (Rechtslauf)                *
*****************************************************************/

extern "C" __declspec(dllexport) int __stdcall MoveUp(int Geschwindigkeit, unsigned int Zeit1, unsigned int Zeit2, unsigned int DurchlAnz);

/****************************************************************
*                                                               *
*                       MoveDown                                *
*                                                               *
* Funktion zur Steuerung des Motors (Linkkslauf)                *
*****************************************************************/

extern "C" __declspec(dllexport) int __stdcall MoveDown(int Geschwindigkeit, unsigned int Zeit1, unsigned int Zeit2, bool Messkr_K1, unsigned int DurchlAnz);


/****************************************************************
*                                                               *
*                       DrehzahlOffset                          *
*                                                               *
* Einstellen des Drehzahl-Offsets ber DAC Kanal D              *
*****************************************************************/

extern "C" __declspec(dllexport) int __stdcall DrehzahlOffset (unsigned int Offset);

/****************************************************************
*                                                               *
*                       GetGeschwindigkeit                      *
*                                                               *
* Funktion zur Bereitstellung der Geschwindkeit des UniMotors   *
* (Der Geschwindigkeitswert ist in einer .ini-Datei abgelegt.)  *
*****************************************************************/

extern "C" __declspec(dllexport) char* __stdcall GetGeschwindigkeit(const char* IniDateiname, char* AuswGeschw, int* WertGeschw);

/****************************************************************
*                                                               *
*                       Zeitgeber                               *
*                                                               *
* Erzeugen einer Zeitverzgerung (Parameter: Timerzeit in ms)   *
*****************************************************************/

void Zeitgeber(int);



#endif


