#ifndef Reader_InterfaceH
#define Reader_InterfaceH

//-------------------------------------------------------------
//Header-File for partial implementation of iid_driver_ce10.dll
//-------------------------------------------------------------
//-author: SJ / MSS--------------------------------------------
//-last modified: 2004-06-23-----------------------------------
//------2005-08-05 - modification to iiddrv30.dll (iID3000-----
//-------------------system)-----------------------------------
//------2007-07 - iID3000 PRO Sample code----------------------
//----------------mod. for iiddrv30_pro.dll--------------------
//-------------------------------------------------------------
//-------------------------------------------------------------

//constants for setting masks for iID driver functions 
const	int GROUP_ISO15693 = 1;
const	int GROUP_IID_L   = 2;
const   int GROUP_IID_D    = 4;
const   int GROUP_IID_G	   = 8;
const   int GROUP_64BITRO  = 16;	

//define DLL-functions 
typedef HANDLE	(CALLBACK* MP_reader_open_interface) (LPTSTR lpszPort);
typedef BYTE	(CALLBACK* MP_reader_close_interface) (HANDLE hPort);
typedef HANDLE	(CALLBACK* MP_reader_get_port_state) (HANDLE hPort);
typedef BYTE	(CALLBACK* MP_reader_set_port_type) (BYTE porttype, LPTSTR lpszPort);
typedef BYTE	(CALLBACK* MP_reader_set_interface_type) (INT32 frequency);

typedef HANDLE  (CALLBACK* MP_reader_get_handle) ();
typedef BYTE    (CALLBACK* MP_driver_set_timeout) (INT32 NewTimeOut);
typedef INT32   (CALLBACK* MP_driver_get_timeout) ();
typedef BYTE    (CALLBACK* MP_driver_set_system_mask) (INT32 NewMask);
typedef INT32   (CALLBACK* MP_driver_get_system_mask) ();
typedef BYTE	(CALLBACK* MP_driver_get_driver_version)  (INT32* main_version, INT32* sub_version);

//type definitions for iid-driver-specification
typedef BYTE (CALLBACK* MP_initialize) ();
typedef BYTE (CALLBACK* MP_terminate) ();
//following 3 functions should not be used officially
typedef BYTE (CALLBACK* MP_readBytes) (BYTE identifier[],INT32 from,INT32 length,BYTE *pByteArray);
typedef BYTE (CALLBACK* MP_writeBytes) (BYTE identifier[],INT32 from,INT32 length,BYTE *pByteArray, BYTE lock);
typedef BYTE (CALLBACK* MP_identify) (BYTE *pByteArray);
typedef BYTE (CALLBACK* MP_read_reader_id) (INT32* reader_id, BYTE *pByteArray);

//iID3000 / TELID2 specific functions
typedef BYTE (CALLBACK* MP_iidl_c_read_ro_code) (HANDLE m_HCom,BYTE *pByteArray);
typedef BYTE (CALLBACK* MP_iidl_c_write_ro_code) (HANDLE m_HCom,BYTE *pByteArray,BYTE lock);
typedef BYTE (CALLBACK* MP_iidl_c_write_block_ee_64) (HANDLE m_HCom,int BlockAddress,BYTE *pByteArray);
typedef BYTE (CALLBACK* MP_iidl_c_read_block_ee_64) (HANDLE m_HCom,int BlockAddress,BYTE* pByteArray);
typedef BYTE (CALLBACK* MP_iidl_c_read_in2) (HANDLE m_HCom, BYTE *setting);
typedef BYTE (CALLBACK* MP_telid2io_c_read_in) (HANDLE m_HCom, BYTE *setting);
typedef BYTE (CALLBACK* MP_telid2io_c_set_out) (HANDLE m_HCom, BYTE setting);
typedef BYTE (CALLBACK* MP_c_reader_set_auto_off_iid3000) (HANDLE m_HCom, BYTE setting);

//necessary for emulation
typedef int (CALLBACK* MP_emul_On) ();
typedef int (CALLBACK* MP_emul_Off) ();
typedef int (CALLBACK* MP_tagAppeared) ();
typedef int (CALLBACK* MP_tagDisappeared) ();


//Variables
MP_reader_open_interface PROC_reader_openinterface;
MP_reader_close_interface PROC_reader_closeinterface;
MP_reader_get_port_state PROC_reader_get_port_state;
MP_reader_set_port_type PROC_reader_set_port_type;
MP_reader_set_interface_type PROC_reader_set_interface_type;
MP_reader_get_handle PROC_reader_get_handle;
MP_driver_set_timeout PROC_driver_set_timeout;
MP_driver_get_timeout PROC_driver_get_timeout;
MP_driver_set_system_mask PROC_driver_set_system_mask;
MP_driver_get_system_mask PROC_driver_get_system_mask;
MP_driver_get_driver_version PROC_driver_get_driver_version;

//functions for iid-driver-specification
MP_initialize PROC_initialize;
MP_terminate PROC_terminate;
MP_readBytes PROC_readBytes;
MP_writeBytes PROC_writeBytes;
MP_identify PROC_identify;
MP_read_reader_id PROC_read_reader_id;
//iID3000 / TELID2 specific functions
MP_iidl_c_read_ro_code PROC_iidl_c_read_ro_code;
MP_iidl_c_write_ro_code PROC_iidl_c_write_ro_code;
MP_iidl_c_write_block_ee_64 PROC_iidl_c_write_block_ee_64;
MP_iidl_c_read_block_ee_64 PROC_iidl_c_read_block_ee_64;
MP_iidl_c_read_in2 PROC_iidl_c_read_in2;
MP_telid2io_c_read_in PROC_telid2io_c_read_in;
MP_telid2io_c_set_out PROC_telid2io_c_set_out;
MP_c_reader_set_auto_off_iid3000 PROC_c_reader_set_auto_off_iid3000;
//necessary for emulation
MP_emul_On PROC_emul_On;
MP_emul_Off PROC_emul_Off;
MP_tagAppeared PROC_tagAppeared;
MP_tagDisappeared PROC_tagDisappeared;

#endif

//global variables e.g. for Port-Handle
BYTE  ReadArray[100];
BYTE  WriteArray[100];
int	  Reader_Id, Reader_Ver;
int	  MSS_Result;
long  wait;	

void SuccessBeep();
void FailBeep();

BOOL Init_Driver(LPTSTR lpszDriverName);


BOOL Init_Driver(LPTSTR lpszDriverName)
{
	
	HINSTANCE DLL_Handle;
	
	//---------- LINK DLL --------------------------
	DLL_Handle = NULL;
	DLL_Handle=LoadLibrary(lpszDriverName);
	if (DLL_Handle == NULL) return FALSE;

	PROC_reader_openinterface=(MP_reader_open_interface) GetProcAddress(DLL_Handle,_T("c_openinterface"));
	if (PROC_reader_openinterface==NULL) return FALSE;
	PROC_reader_closeinterface=(MP_reader_close_interface) GetProcAddress(DLL_Handle,_T("c_closeinterface"));
	if (PROC_reader_closeinterface==NULL) return FALSE;
	PROC_reader_get_port_state=(MP_reader_get_port_state) GetProcAddress(DLL_Handle,_T("c_get_port_state"));
	if (PROC_reader_get_port_state==NULL) return FALSE;
	PROC_reader_set_port_type=(MP_reader_set_port_type) GetProcAddress(DLL_Handle,_T("c_set_port_type"));
	if (PROC_reader_set_port_type==NULL) return FALSE;
	PROC_reader_set_interface_type=(MP_reader_set_interface_type) GetProcAddress(DLL_Handle,_T("c_set_interface_type"));
	if (PROC_reader_set_interface_type==NULL) return FALSE;
	PROC_reader_get_handle=(MP_reader_get_handle) GetProcAddress(DLL_Handle,_T("c_get_handle"));
	if (PROC_reader_get_handle==NULL) return FALSE;
	PROC_driver_set_timeout=(MP_driver_set_timeout) GetProcAddress(DLL_Handle,_T("c_set_timeout"));
	if (PROC_driver_set_timeout==NULL) return FALSE;
	PROC_driver_get_timeout=(MP_driver_get_timeout) GetProcAddress(DLL_Handle,_T("c_get_timeout"));
	if (PROC_driver_get_timeout==NULL) return FALSE;
	PROC_driver_set_system_mask=(MP_driver_set_system_mask) GetProcAddress(DLL_Handle,_T("c_set_system_mask"));
	if (PROC_driver_set_system_mask==NULL) return FALSE;
	PROC_driver_get_system_mask=(MP_driver_get_system_mask) GetProcAddress(DLL_Handle,_T("c_get_system_mask"));
	if (PROC_driver_get_system_mask==NULL) return FALSE;
	PROC_driver_get_driver_version=(MP_driver_get_driver_version) GetProcAddress(DLL_Handle,_T("c_get_driver_version"));
	if (PROC_driver_get_driver_version==NULL) return FALSE;

	//general instructions for SAP-interface
	PROC_initialize=(MP_initialize) GetProcAddress(DLL_Handle,_T("c_initialize"));
	if (PROC_initialize==NULL) return FALSE;
	PROC_terminate=(MP_terminate) GetProcAddress(DLL_Handle,_T("c_terminate"));
	if (PROC_terminate==NULL) return FALSE;
	PROC_readBytes=(MP_readBytes) GetProcAddress(DLL_Handle,_T("c_readbytes"));
	if (PROC_readBytes==NULL) return FALSE;
	PROC_writeBytes=(MP_writeBytes) GetProcAddress(DLL_Handle,_T("c_writebytes"));
	if (PROC_writeBytes==NULL) return FALSE;
	PROC_identify=(MP_identify) GetProcAddress(DLL_Handle,_T("c_identify"));
	if (PROC_identify==NULL) return FALSE;
	PROC_emul_On=(MP_emul_On) GetProcAddress(DLL_Handle,_T("c_emul_on"));
	if (PROC_emul_On==NULL) return FALSE;
	PROC_emul_Off=(MP_emul_Off) GetProcAddress(DLL_Handle,_T("c_emul_off"));
	if (PROC_emul_Off==NULL) return FALSE;
	PROC_tagAppeared=(MP_tagAppeared) GetProcAddress(DLL_Handle,_T("c_tag_appeared"));
	if (PROC_tagAppeared==NULL) return FALSE;
	PROC_tagDisappeared=(MP_tagDisappeared) GetProcAddress(DLL_Handle,_T("c_tag_disappeared"));
	if (PROC_tagDisappeared==NULL) return FALSE;
	PROC_read_reader_id=(MP_read_reader_id) GetProcAddress(DLL_Handle,_T("c_read_reader_id"));
	if (PROC_read_reader_id==NULL) return FALSE;

	//iID3000 / TELID2 specific functions
	PROC_iidl_c_read_ro_code=(MP_iidl_c_read_ro_code) GetProcAddress(DLL_Handle,_T("iidl_c_read_ro_code"));
	if (PROC_iidl_c_read_ro_code==NULL) return FALSE;
	PROC_iidl_c_write_ro_code=(MP_iidl_c_write_ro_code) GetProcAddress(DLL_Handle,_T("iidl_c_write_ro_code"));
	if (PROC_iidl_c_write_ro_code==NULL) return FALSE;
	PROC_iidl_c_read_block_ee_64=(MP_iidl_c_read_block_ee_64) GetProcAddress(DLL_Handle,_T("iidl_c_read_block_ee_64"));
	if (PROC_iidl_c_read_block_ee_64==NULL) return FALSE;
	PROC_iidl_c_write_block_ee_64=(MP_iidl_c_write_block_ee_64) GetProcAddress(DLL_Handle,_T("iidl_c_write_block_ee_64"));
	if (PROC_iidl_c_write_block_ee_64==NULL) return FALSE;
	PROC_iidl_c_read_in2=(MP_iidl_c_read_in2) GetProcAddress(DLL_Handle,_T("iidl_c_read_in2"));
	if (PROC_iidl_c_read_in2==NULL) return FALSE;
	PROC_telid2io_c_read_in=(MP_telid2io_c_read_in) GetProcAddress(DLL_Handle,_T("telid2io_c_read_in"));
	if (PROC_telid2io_c_read_in==NULL) return FALSE;
	PROC_telid2io_c_set_out=(MP_telid2io_c_set_out) GetProcAddress(DLL_Handle,_T("telid2io_c_set_out"));
	if (PROC_telid2io_c_set_out==NULL) return FALSE;

	PROC_c_reader_set_auto_off_iid3000=(MP_c_reader_set_auto_off_iid3000) GetProcAddress(DLL_Handle,_T("c_reader_set_auto_off_iid3000"));
	if (PROC_c_reader_set_auto_off_iid3000==NULL) return FALSE;

	return TRUE;
}