//-------------------------------------------------------------
//--History : 2005-06-09 - based on RFID demo .Net frame-------
//------------work - create sample code C#---------------------
//-------------------------------------------------------------

//#define WINCENET
#define PC
//#define POCKETPC

using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.Data;
using MICROSENSYS.RFIDReader;
using System.Runtime.InteropServices;
// The following directives were added to make the code 
// in the LoadColumns() and DisplayAppSettings() functions more readable.
// This allows classes in these namespaces to be referenced without
// a fully-qualified name.
using System.Collections.Specialized;
using System.Configuration;


namespace MICROSENSYS.ClassTest
{
	/// <summary>
	/// Zusammenfassung fr Form1.
	/// </summary>
	public class Form_Main : System.Windows.Forms.Form
	{
		private	static String OLD_UIDText="";
		private int i, ergeb;
		private static String Strg;
		private System.Windows.Forms.StatusBar StatusBar_Main;
		private System.Windows.Forms.MainMenu mainMenu;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItem_COM1;
		private System.Windows.Forms.MenuItem menuItem_COM2;
		private System.Windows.Forms.MenuItem menuItem_COM3;
		private System.Windows.Forms.MenuItem menuItem_COM4;
		private System.Windows.Forms.MenuItem menuItem_COM5;
		private System.Windows.Forms.MenuItem menuItem_COM6;
		private System.Windows.Forms.TabPage tabPage_Identify;
		private System.Windows.Forms.Button button_ReadTag;
		private System.Windows.Forms.Timer Timer_Scan;
		private	bool cancelread;
		private System.Windows.Forms.Button button_Cancel;
		private System.Windows.Forms.ListBox listBox_UID;
		private System.Windows.Forms.TabControl tabControl_Main;
		private System.Windows.Forms.Timer Timer_CheckReader;
		private System.Windows.Forms.CheckBox checkBox_FilterUID;
        private System.Windows.Forms.ProgressBar progressBar;
		private System.Windows.Forms.MenuItem menuItem_About;
		private System.Windows.Forms.MenuItem menuItem_COM7;
		private System.Windows.Forms.MenuItem menuItem_COM8;
		private System.Windows.Forms.Button button_CancelText;
		private System.Windows.Forms.Button button_ReadText;
		private System.Windows.Forms.Button button_WriteText;
		private System.Windows.Forms.Timer Timer_ReadText;
		private System.Windows.Forms.TextBox Edit_TextDemo;
		private System.Windows.Forms.Timer Timer_WriteText;
		private System.Windows.Forms.TabPage tabPage_TextDemo;
		private System.Windows.Forms.Panel panel_ReadWrite;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem_BTSPP;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItem_1356;
		private System.Windows.Forms.MenuItem menuItem_Serial;
		private System.Windows.Forms.MenuItem menuItem_BLUESPP;
		private System.Windows.Forms.MenuItem menuItem_CF;
		private System.Windows.Forms.MenuItem menuItem_125;
		private System.Windows.Forms.MenuItem menuItem_COM9;
		private System.Windows.Forms.MenuItem menuItem_COM10;
		private System.Windows.Forms.MenuItem menuItem_COM11;
		private System.Windows.Forms.MenuItem menuItem_COM12;
		private System.Windows.Forms.MenuItem menuItem_COM13;
		private System.Windows.Forms.MenuItem menuItem_COM14;
		private System.Windows.Forms.MenuItem menuItem_USB;
		private System.Windows.Forms.TabPage tabPage_Settings;
		private System.Windows.Forms.Panel panel_System;
		private System.Windows.Forms.CheckBox checkBox_ISO15693_Enable;
		private System.Windows.Forms.CheckBox checkBox_ICode1_Enable;
		private System.Windows.Forms.CheckBox checkBox_ARIO_Enable;
		private System.Windows.Forms.CheckBox checkBox_iIDG_Enable;
		private System.Windows.Forms.CheckBox checkBox_iIDD_Enable;
		private System.Windows.Forms.NumericUpDown numericUpDown_Timeout;
		private System.Windows.Forms.Label label_Timeout;
		private System.Windows.Forms.MenuItem menuItem_pen_mem;
	
		private System.Windows.Forms.CheckBox checkBox_ICodeUID_Enable;
        private MenuItem menuItem_Quit;
		
		RFIDClass Reader;
        CommonFunc CommonF;
		
		public string ErrorText 
		{
			get {return String.Format("ERROR: Operation Result was: {0}.", 	ergeb);	}
		}

		public Form_Main()
		{
			//
			// Erforderlich fr die Windows Form-Designeruntersttzung
			//
			InitializeComponent();

			//Adjust the Screen for fitting on all devices

			button_Cancel.BackColor=Color.Red;
			button_CancelText.BackColor=Color.Red;
			listBox_UID.BackColor=Color.WhiteSmoke;

			tabPage_Identify.BackColor=Color.Gray;
			tabPage_TextDemo.BackColor=Color.DimGray;

			tabControl_Main.Left=10;
			tabControl_Main.Width=Screen.PrimaryScreen.WorkingArea.Width-20;
			
			#if WINCENET
			tabControl_Main.Height=Screen.PrimaryScreen.WorkingArea.Height-(StatusBar_Main.Height * 3)-progressBar.Height;
			#endif
			
			#if PC
			tabControl_Main.Height=Screen.PrimaryScreen.WorkingArea.Height-(StatusBar_Main.Height * 4)-progressBar.Height;
			#endif

			#if POCKETPC
			//Komponenten anordnen, wenn kein Startmen auf Bildschirm
			tabControl_Main.Height=Screen.PrimaryScreen.WorkingArea.Height-(StatusBar_Main.Height * 2)-progressBar.Height;
			#endif

			//Align progressbar under tabcontrol
			progressBar.Left=0;
			progressBar.Top=tabControl_Main.Top + tabControl_Main.Height;
			progressBar.Width=Screen.PrimaryScreen.WorkingArea.Width;
			
			listBox_UID.Left=10;
			listBox_UID.Width=tabControl_Main.Width-20;
			listBox_UID.Height=tabControl_Main.Height-100;

			Edit_TextDemo.Left=10;
			Edit_TextDemo.Width=tabControl_Main.Width-20;
			Edit_TextDemo.Height=tabControl_Main.Height-100;

			Reader = new RFIDClass();
            CommonF = new CommonFunc();

			InitSettings_AndReader();
		}
		/// <summary>
		/// Verwendete Ressourcen bereinigen.
		/// </summary>

		//Try to initialize reader
		private void InitSettings_AndReader()
		{
			this.StatusBar_Main.Text="Loading...";
			this.Refresh();

			Reader.PortName = "COM1:";		//standard port name = COM1:
			Reader.PortType = 0;			//standard port type = serial
			//0==serial port/CF port
			//1==CF-port via elserial (only for PPC 2000 systems)
			//2==BT serial port
			//4=USB port (only WIN32 systems)
			Reader.InterfaceType = 1356;	//13,56MHz = standard
			//125==125kHz
			//1356==1356MHz
			//0x10==PEN-BT with memory support
			Reader.DriverTimeOut = 250;		//250msec timeout, if no tag found
			Reader.DriverSystemMask = 0xFF;	//handle all transponders as standard

			Reader.Driver_SetParameters();
			Reader.Reader_OpenInterface();
			
			if (Reader.Port_Initialized==0) 
			{
				//communiacation port not initialized, load default values
				Reader.PortName = "COM1:";		//standard port name = COM1:
				Reader.PortType = 0;			//standard port type = serial
				//0==serial port/CF port
				//1==CF-port via elserial (only for PPC 2000 systems)
				//2==BT serial port
				//4=USB port (only WIN32 systems)
				Reader.InterfaceType = 1356;	//13,56MHz = standard
				//125==125kHz
				//1356==1356MHz
				//0x10==PEN-BT with memory support
				Reader.DriverTimeOut = 350;		//250msec timeout, if no tag found
				Reader.DriverSystemMask = 0xFF;	//handle all transponders as standard
				Reader.Driver_SetParameters();
				this.StatusBar_Main.Text="Port not valid. Defaults loaded...";
				return;
			}

			UncheckMenues();
			switch (Reader.PortName)
			{
				case "COM1:" : menuItem_COM1.Checked=true; break;
				case "COM2:" : menuItem_COM2.Checked=true; break;
				case "COM3:" : menuItem_COM3.Checked=true; break;
				case "COM4:" : menuItem_COM4.Checked=true; break;
				case "COM5:" : menuItem_COM5.Checked=true; break;
				case "COM6:" : menuItem_COM6.Checked=true; break;
				case "COM7:" : menuItem_COM7.Checked=true; break;
				case "COM8:" : menuItem_COM8.Checked=true; break;
				case "COM9:" : menuItem_COM9.Checked=true; break;
				case "COM10:" : menuItem_COM10.Checked=true; break;
				case "COM11:" : menuItem_COM11.Checked=true; break;
				case "COM12:" : menuItem_COM12.Checked=true; break;
				case "COM13:" : menuItem_COM13.Checked=true; break;
				case "COM14:" : menuItem_COM14.Checked=true; break;
			}
			
			menuItem_Serial.Checked=false;
			menuItem_CF.Checked=false;
			menuItem_BLUESPP.Checked=false;
			menuItem_USB.Checked=false;			
			switch (Reader.PortType) 
			{
				case 0 :	menuItem_Serial.Checked=true; break;
				case 1 :	menuItem_CF.Checked=true; break;
				case 2 :	menuItem_BLUESPP.Checked=true; break;
				case 4 :	menuItem_USB.Checked=true; break;
			}
			
			//added 2005-05-23
			this.menuItem_1356.Checked=false;
			this.menuItem_125.Checked=false;
			this.menuItem_pen_mem.Checked=false;
			switch (Reader.InterfaceType) 
			{
				case 125 :	menuItem_125.Checked=true; break;
				case 1356 :	menuItem_1356.Checked=true; break;
				case 0x10 :	menuItem_pen_mem.Checked=true; break;
			}

			if ((Reader.DriverSystemMask & 1) != 0) checkBox_ISO15693_Enable.Checked=true; else checkBox_ISO15693_Enable.Checked=false;
			if ((Reader.DriverSystemMask & 2) != 0) checkBox_ICode1_Enable.Checked=true; else checkBox_ICode1_Enable.Checked=false;
			if ((Reader.DriverSystemMask & 4) != 0) checkBox_iIDD_Enable.Checked=true; else checkBox_iIDD_Enable.Checked=false;
			if ((Reader.DriverSystemMask & 8) != 0) checkBox_iIDG_Enable.Checked=true; else checkBox_iIDG_Enable.Checked=false;
			if ((Reader.DriverSystemMask & 0x10) != 0) checkBox_ARIO_Enable.Checked=true; else checkBox_ARIO_Enable.Checked=false;
			if ((Reader.DriverSystemMask & 0x20) != 0) checkBox_ICodeUID_Enable.Checked=true; else checkBox_ICodeUID_Enable.Checked=false;

			this.numericUpDown_Timeout.Value=Reader.DriverTimeOut;

			//2005-05-23: bei USB erst spter nach reader suchen
			if (Reader.Reader_Connected==1)
				{
				Strg=String.Format("READER ID {0}, driver ver {1}.{2} initialized.", Reader.Reader_Id, Reader.Version_Main_Driver_Engine, Reader.Version_Sub_Driver_Engine);					
				StatusBar_Main.Text=Strg;
				CommonF.SuccessBeep();
				}
				else
				{
				StatusBar_Main.Text=String.Format("No READER connected, driver ver {0}.{1} initialized.", Reader.Version_Main_Driver_Engine, Reader.Version_Sub_Driver_Engine);					
				}
			Timer_CheckReader.Enabled=true;
			}
		
		protected override void Dispose( bool disposing )
		{
			Timer_Scan.Enabled=false;
			Timer_CheckReader.Enabled=false;
			Timer_ReadText.Enabled=false;
			Reader.Reader_CloseInterface();
			
			CommonF.SuccessBeep();

			base.Dispose( disposing );
		}
		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
            this.StatusBar_Main = new System.Windows.Forms.StatusBar();
            this.mainMenu = new System.Windows.Forms.MainMenu();
            this.menuItem1 = new System.Windows.Forms.MenuItem();
            this.menuItem_About = new System.Windows.Forms.MenuItem();
            this.menuItem_Quit = new System.Windows.Forms.MenuItem();
            this.menuItem2 = new System.Windows.Forms.MenuItem();
            this.menuItem_BTSPP = new System.Windows.Forms.MenuItem();
            this.menuItem_Serial = new System.Windows.Forms.MenuItem();
            this.menuItem_BLUESPP = new System.Windows.Forms.MenuItem();
            this.menuItem_CF = new System.Windows.Forms.MenuItem();
            this.menuItem_USB = new System.Windows.Forms.MenuItem();
            this.menuItem4 = new System.Windows.Forms.MenuItem();
            this.menuItem_125 = new System.Windows.Forms.MenuItem();
            this.menuItem_1356 = new System.Windows.Forms.MenuItem();
            this.menuItem_pen_mem = new System.Windows.Forms.MenuItem();
            this.menuItem3 = new System.Windows.Forms.MenuItem();
            this.menuItem_COM1 = new System.Windows.Forms.MenuItem();
            this.menuItem_COM2 = new System.Windows.Forms.MenuItem();
            this.menuItem_COM3 = new System.Windows.Forms.MenuItem();
            this.menuItem_COM4 = new System.Windows.Forms.MenuItem();
            this.menuItem_COM5 = new System.Windows.Forms.MenuItem();
            this.menuItem_COM6 = new System.Windows.Forms.MenuItem();
            this.menuItem_COM7 = new System.Windows.Forms.MenuItem();
            this.menuItem_COM8 = new System.Windows.Forms.MenuItem();
            this.menuItem_COM9 = new System.Windows.Forms.MenuItem();
            this.menuItem_COM10 = new System.Windows.Forms.MenuItem();
            this.menuItem_COM11 = new System.Windows.Forms.MenuItem();
            this.menuItem_COM12 = new System.Windows.Forms.MenuItem();
            this.menuItem_COM13 = new System.Windows.Forms.MenuItem();
            this.menuItem_COM14 = new System.Windows.Forms.MenuItem();
            this.tabControl_Main = new System.Windows.Forms.TabControl();
            this.tabPage_Identify = new System.Windows.Forms.TabPage();
            this.checkBox_FilterUID = new System.Windows.Forms.CheckBox();
            this.listBox_UID = new System.Windows.Forms.ListBox();
            this.button_Cancel = new System.Windows.Forms.Button();
            this.button_ReadTag = new System.Windows.Forms.Button();
            this.tabPage_TextDemo = new System.Windows.Forms.TabPage();
            this.panel_ReadWrite = new System.Windows.Forms.Panel();
            this.Edit_TextDemo = new System.Windows.Forms.TextBox();
            this.button_WriteText = new System.Windows.Forms.Button();
            this.button_ReadText = new System.Windows.Forms.Button();
            this.button_CancelText = new System.Windows.Forms.Button();
            this.tabPage_Settings = new System.Windows.Forms.TabPage();
            this.label_Timeout = new System.Windows.Forms.Label();
            this.numericUpDown_Timeout = new System.Windows.Forms.NumericUpDown();
            this.panel_System = new System.Windows.Forms.Panel();
            this.checkBox_ICodeUID_Enable = new System.Windows.Forms.CheckBox();
            this.checkBox_ARIO_Enable = new System.Windows.Forms.CheckBox();
            this.checkBox_iIDG_Enable = new System.Windows.Forms.CheckBox();
            this.checkBox_iIDD_Enable = new System.Windows.Forms.CheckBox();
            this.checkBox_ICode1_Enable = new System.Windows.Forms.CheckBox();
            this.checkBox_ISO15693_Enable = new System.Windows.Forms.CheckBox();
            this.Timer_Scan = new System.Windows.Forms.Timer();
            this.Timer_CheckReader = new System.Windows.Forms.Timer();
            this.progressBar = new System.Windows.Forms.ProgressBar();
            this.Timer_ReadText = new System.Windows.Forms.Timer();
            this.Timer_WriteText = new System.Windows.Forms.Timer();
            this.tabControl_Main.SuspendLayout();
            this.tabPage_Identify.SuspendLayout();
            this.tabPage_TextDemo.SuspendLayout();
            this.tabPage_Settings.SuspendLayout();
            this.panel_System.SuspendLayout();
            this.SuspendLayout();
            // 
            // StatusBar_Main
            // 
            this.StatusBar_Main.Location = new System.Drawing.Point(0, 433);
            this.StatusBar_Main.Name = "StatusBar_Main";
            this.StatusBar_Main.Size = new System.Drawing.Size(638, 22);
            this.StatusBar_Main.Text = "Reader not initialized...";
            // 
            // mainMenu
            // 
            this.mainMenu.MenuItems.Add(this.menuItem1);
            this.mainMenu.MenuItems.Add(this.menuItem2);
            this.mainMenu.MenuItems.Add(this.menuItem3);
            // 
            // menuItem1
            // 
            this.menuItem1.MenuItems.Add(this.menuItem_About);
            this.menuItem1.MenuItems.Add(this.menuItem_Quit);
            this.menuItem1.Text = "Program";
            // 
            // menuItem_About
            // 
            this.menuItem_About.Text = "About";
            this.menuItem_About.Click += new System.EventHandler(this.menuItem_About_Click);
            // 
            // menuItem_Quit
            // 
            this.menuItem_Quit.Text = "Quit";
            this.menuItem_Quit.Click += new System.EventHandler(this.menuItem_Quit_Click);
            // 
            // menuItem2
            // 
            this.menuItem2.MenuItems.Add(this.menuItem_BTSPP);
            this.menuItem2.MenuItems.Add(this.menuItem4);
            this.menuItem2.Text = "Options";
            // 
            // menuItem_BTSPP
            // 
            this.menuItem_BTSPP.MenuItems.Add(this.menuItem_Serial);
            this.menuItem_BTSPP.MenuItems.Add(this.menuItem_BLUESPP);
            this.menuItem_BTSPP.MenuItems.Add(this.menuItem_CF);
            this.menuItem_BTSPP.MenuItems.Add(this.menuItem_USB);
            this.menuItem_BTSPP.Text = "Peripheral settings";
            // 
            // menuItem_Serial
            // 
            this.menuItem_Serial.Checked = true;
            this.menuItem_Serial.Text = "Standard serial";
            this.menuItem_Serial.Click += new System.EventHandler(this.menuItem_Serial_Click);
            // 
            // menuItem_BLUESPP
            // 
            this.menuItem_BLUESPP.Text = "Bluetooth SPP (online/mem)";
            this.menuItem_BLUESPP.Click += new System.EventHandler(this.menuItem_BLUESPP_Click);
            // 
            // menuItem_CF
            // 
            this.menuItem_CF.Text = "Compact-Flash direct (only special mobile devices)";
            this.menuItem_CF.Click += new System.EventHandler(this.menuItem_CF_Click);
            // 
            // menuItem_USB
            // 
            this.menuItem_USB.Text = "USB (only PC)";
            this.menuItem_USB.Click += new System.EventHandler(this.menuItem_USB_Click);
            // 
            // menuItem4
            // 
            this.menuItem4.MenuItems.Add(this.menuItem_125);
            this.menuItem4.MenuItems.Add(this.menuItem_1356);
            this.menuItem4.MenuItems.Add(this.menuItem_pen_mem);
            this.menuItem4.Text = "Interface type";
            // 
            // menuItem_125
            // 
            this.menuItem_125.Text = "125 kHz";
            this.menuItem_125.Click += new System.EventHandler(this.menuItem125_Click);
            // 
            // menuItem_1356
            // 
            this.menuItem_1356.Checked = true;
            this.menuItem_1356.Text = "13.56 MHz";
            this.menuItem_1356.Click += new System.EventHandler(this.menuItem_1356_Click);
            // 
            // menuItem_pen_mem
            // 
            this.menuItem_pen_mem.Text = "PEN-BT PRO with memory support";
            this.menuItem_pen_mem.Click += new System.EventHandler(this.menuItem_pen_mem_Click);
            // 
            // menuItem3
            // 
            this.menuItem3.MenuItems.Add(this.menuItem_COM1);
            this.menuItem3.MenuItems.Add(this.menuItem_COM2);
            this.menuItem3.MenuItems.Add(this.menuItem_COM3);
            this.menuItem3.MenuItems.Add(this.menuItem_COM4);
            this.menuItem3.MenuItems.Add(this.menuItem_COM5);
            this.menuItem3.MenuItems.Add(this.menuItem_COM6);
            this.menuItem3.MenuItems.Add(this.menuItem_COM7);
            this.menuItem3.MenuItems.Add(this.menuItem_COM8);
            this.menuItem3.MenuItems.Add(this.menuItem_COM9);
            this.menuItem3.MenuItems.Add(this.menuItem_COM10);
            this.menuItem3.MenuItems.Add(this.menuItem_COM11);
            this.menuItem3.MenuItems.Add(this.menuItem_COM12);
            this.menuItem3.MenuItems.Add(this.menuItem_COM13);
            this.menuItem3.MenuItems.Add(this.menuItem_COM14);
            this.menuItem3.Text = "Initialize Reader";
            // 
            // menuItem_COM1
            // 
            this.menuItem_COM1.Text = "COM1:";
            this.menuItem_COM1.Click += new System.EventHandler(this.menuItem_COM1_Click);
            // 
            // menuItem_COM2
            // 
            this.menuItem_COM2.Text = "COM2:";
            this.menuItem_COM2.Click += new System.EventHandler(this.menuItem_COM2_Click);
            // 
            // menuItem_COM3
            // 
            this.menuItem_COM3.Text = "COM3:";
            this.menuItem_COM3.Click += new System.EventHandler(this.menuItem_COM3_Click);
            // 
            // menuItem_COM4
            // 
            this.menuItem_COM4.Text = "COM4:";
            this.menuItem_COM4.Click += new System.EventHandler(this.menuItem_COM4_Click);
            // 
            // menuItem_COM5
            // 
            this.menuItem_COM5.Text = "COM5:";
            this.menuItem_COM5.Click += new System.EventHandler(this.menuItem_COM5_Click);
            // 
            // menuItem_COM6
            // 
            this.menuItem_COM6.Text = "COM6:";
            this.menuItem_COM6.Click += new System.EventHandler(this.menuItem_COM6_Click);
            // 
            // menuItem_COM7
            // 
            this.menuItem_COM7.Text = "COM7:";
            this.menuItem_COM7.Click += new System.EventHandler(this.menuItem_COM7_Click);
            // 
            // menuItem_COM8
            // 
            this.menuItem_COM8.Text = "COM8:";
            this.menuItem_COM8.Click += new System.EventHandler(this.menuItem_COM8_Click);
            // 
            // menuItem_COM9
            // 
            this.menuItem_COM9.Text = "COM9:";
            this.menuItem_COM9.Click += new System.EventHandler(this.menuItem_COM9_Click);
            // 
            // menuItem_COM10
            // 
            this.menuItem_COM10.Text = "COM10:";
            this.menuItem_COM10.Click += new System.EventHandler(this.menuItem_COM10_Click);
            // 
            // menuItem_COM11
            // 
            this.menuItem_COM11.Text = "COM11:";
            this.menuItem_COM11.Click += new System.EventHandler(this.menuItem_COM11_Click);
            // 
            // menuItem_COM12
            // 
            this.menuItem_COM12.Text = "COM12:";
            this.menuItem_COM12.Click += new System.EventHandler(this.menuItem_COM12_Click);
            // 
            // menuItem_COM13
            // 
            this.menuItem_COM13.Text = "COM13:";
            this.menuItem_COM13.Click += new System.EventHandler(this.menuItem_COM13_Click);
            // 
            // menuItem_COM14
            // 
            this.menuItem_COM14.Text = "COM14:";
            this.menuItem_COM14.Click += new System.EventHandler(this.menuItem_COM14_Click);
            // 
            // tabControl_Main
            // 
            this.tabControl_Main.Controls.Add(this.tabPage_Identify);
            this.tabControl_Main.Controls.Add(this.tabPage_TextDemo);
            this.tabControl_Main.Controls.Add(this.tabPage_Settings);
            this.tabControl_Main.Location = new System.Drawing.Point(0, 0);
            this.tabControl_Main.Name = "tabControl_Main";
            this.tabControl_Main.SelectedIndex = 0;
            this.tabControl_Main.Size = new System.Drawing.Size(638, 192);
            this.tabControl_Main.TabIndex = 2;
            this.tabControl_Main.SelectedIndexChanged += new System.EventHandler(this.tabControl_Main_SelectedIndexChanged);
            // 
            // tabPage_Identify
            // 
            this.tabPage_Identify.Controls.Add(this.checkBox_FilterUID);
            this.tabPage_Identify.Controls.Add(this.listBox_UID);
            this.tabPage_Identify.Controls.Add(this.button_Cancel);
            this.tabPage_Identify.Controls.Add(this.button_ReadTag);
            this.tabPage_Identify.Location = new System.Drawing.Point(0, 0);
            this.tabPage_Identify.Name = "tabPage_Identify";
            this.tabPage_Identify.Size = new System.Drawing.Size(638, 169);
            this.tabPage_Identify.Text = "Identify";
            // 
            // checkBox_FilterUID
            // 
            this.checkBox_FilterUID.Location = new System.Drawing.Point(10, 40);
            this.checkBox_FilterUID.Name = "checkBox_FilterUID";
            this.checkBox_FilterUID.Size = new System.Drawing.Size(158, 19);
            this.checkBox_FilterUID.TabIndex = 0;
            this.checkBox_FilterUID.Text = "Filter duplicate UID\'s";
            // 
            // listBox_UID
            // 
            this.listBox_UID.Location = new System.Drawing.Point(8, 61);
            this.listBox_UID.Name = "listBox_UID";
            this.listBox_UID.Size = new System.Drawing.Size(192, 72);
            this.listBox_UID.TabIndex = 1;
            // 
            // button_Cancel
            // 
            this.button_Cancel.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
            this.button_Cancel.Location = new System.Drawing.Point(144, 8);
            this.button_Cancel.Name = "button_Cancel";
            this.button_Cancel.Size = new System.Drawing.Size(56, 32);
            this.button_Cancel.TabIndex = 2;
            this.button_Cancel.Text = "Cancel";
            this.button_Cancel.Click += new System.EventHandler(this.button_Cancel_Click);
            // 
            // button_ReadTag
            // 
            this.button_ReadTag.Location = new System.Drawing.Point(8, 8);
            this.button_ReadTag.Name = "button_ReadTag";
            this.button_ReadTag.Size = new System.Drawing.Size(128, 32);
            this.button_ReadTag.TabIndex = 3;
            this.button_ReadTag.Text = "Read Identifier";
            this.button_ReadTag.Click += new System.EventHandler(this.button_ReadTag_Click);
            // 
            // tabPage_TextDemo
            // 
            this.tabPage_TextDemo.Controls.Add(this.panel_ReadWrite);
            this.tabPage_TextDemo.Controls.Add(this.Edit_TextDemo);
            this.tabPage_TextDemo.Controls.Add(this.button_WriteText);
            this.tabPage_TextDemo.Controls.Add(this.button_ReadText);
            this.tabPage_TextDemo.Controls.Add(this.button_CancelText);
            this.tabPage_TextDemo.Location = new System.Drawing.Point(0, 0);
            this.tabPage_TextDemo.Name = "tabPage_TextDemo";
            this.tabPage_TextDemo.Size = new System.Drawing.Size(208, 166);
            this.tabPage_TextDemo.Text = "Textdemo";
            // 
            // panel_ReadWrite
            // 
            this.panel_ReadWrite.Location = new System.Drawing.Point(119, 25);
            this.panel_ReadWrite.Name = "panel_ReadWrite";
            this.panel_ReadWrite.Size = new System.Drawing.Size(16, 16);
            // 
            // Edit_TextDemo
            // 
            this.Edit_TextDemo.AcceptsReturn = true;
            this.Edit_TextDemo.Font = new System.Drawing.Font("Microsoft Sans Serif", 11F, System.Drawing.FontStyle.Bold);
            this.Edit_TextDemo.Location = new System.Drawing.Point(8, 64);
            this.Edit_TextDemo.MaxLength = 256;
            this.Edit_TextDemo.Multiline = true;
            this.Edit_TextDemo.Name = "Edit_TextDemo";
            this.Edit_TextDemo.ScrollBars = System.Windows.Forms.ScrollBars.Both;
            this.Edit_TextDemo.Size = new System.Drawing.Size(192, 96);
            this.Edit_TextDemo.TabIndex = 1;
            // 
            // button_WriteText
            // 
            this.button_WriteText.Location = new System.Drawing.Point(8, 8);
            this.button_WriteText.Name = "button_WriteText";
            this.button_WriteText.Size = new System.Drawing.Size(104, 24);
            this.button_WriteText.TabIndex = 2;
            this.button_WriteText.Text = "Write Text";
            this.button_WriteText.Click += new System.EventHandler(this.button_WriteText_Click);
            // 
            // button_ReadText
            // 
            this.button_ReadText.Location = new System.Drawing.Point(8, 32);
            this.button_ReadText.Name = "button_ReadText";
            this.button_ReadText.Size = new System.Drawing.Size(104, 24);
            this.button_ReadText.TabIndex = 3;
            this.button_ReadText.Text = "Read Text";
            this.button_ReadText.Click += new System.EventHandler(this.button_ReadText_Click);
            // 
            // button_CancelText
            // 
            this.button_CancelText.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
            this.button_CancelText.Location = new System.Drawing.Point(144, 8);
            this.button_CancelText.Name = "button_CancelText";
            this.button_CancelText.Size = new System.Drawing.Size(56, 48);
            this.button_CancelText.TabIndex = 4;
            this.button_CancelText.Text = "Cancel";
            this.button_CancelText.Click += new System.EventHandler(this.button_CancelText_Click);
            // 
            // tabPage_Settings
            // 
            this.tabPage_Settings.Controls.Add(this.label_Timeout);
            this.tabPage_Settings.Controls.Add(this.numericUpDown_Timeout);
            this.tabPage_Settings.Controls.Add(this.panel_System);
            this.tabPage_Settings.Location = new System.Drawing.Point(0, 0);
            this.tabPage_Settings.Name = "tabPage_Settings";
            this.tabPage_Settings.Size = new System.Drawing.Size(208, 166);
            this.tabPage_Settings.Text = "Settings";
            // 
            // label_Timeout
            // 
            this.label_Timeout.Location = new System.Drawing.Point(10, 143);
            this.label_Timeout.Name = "label_Timeout";
            this.label_Timeout.Size = new System.Drawing.Size(96, 16);
            this.label_Timeout.Text = "RF-Timeout (ms):";
            // 
            // numericUpDown_Timeout
            // 
            this.numericUpDown_Timeout.Increment = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.numericUpDown_Timeout.Location = new System.Drawing.Point(115, 140);
            this.numericUpDown_Timeout.Maximum = new decimal(new int[] {
            4999,
            0,
            0,
            0});
            this.numericUpDown_Timeout.Minimum = new decimal(new int[] {
            10,
            0,
            0,
            0});
            this.numericUpDown_Timeout.Name = "numericUpDown_Timeout";
            this.numericUpDown_Timeout.Size = new System.Drawing.Size(80, 22);
            this.numericUpDown_Timeout.TabIndex = 1;
            this.numericUpDown_Timeout.Value = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.numericUpDown_Timeout.ValueChanged += new System.EventHandler(this.numericUpDown_Timeout_ValueChanged);
            // 
            // panel_System
            // 
            this.panel_System.Controls.Add(this.checkBox_ICodeUID_Enable);
            this.panel_System.Controls.Add(this.checkBox_ARIO_Enable);
            this.panel_System.Controls.Add(this.checkBox_iIDG_Enable);
            this.panel_System.Controls.Add(this.checkBox_iIDD_Enable);
            this.panel_System.Controls.Add(this.checkBox_ICode1_Enable);
            this.panel_System.Controls.Add(this.checkBox_ISO15693_Enable);
            this.panel_System.Location = new System.Drawing.Point(8, 8);
            this.panel_System.Name = "panel_System";
            this.panel_System.Size = new System.Drawing.Size(192, 128);
            // 
            // checkBox_ICodeUID_Enable
            // 
            this.checkBox_ICodeUID_Enable.Checked = true;
            this.checkBox_ICodeUID_Enable.CheckState = System.Windows.Forms.CheckState.Checked;
            this.checkBox_ICodeUID_Enable.Location = new System.Drawing.Point(8, 104);
            this.checkBox_ICodeUID_Enable.Name = "checkBox_ICodeUID_Enable";
            this.checkBox_ICodeUID_Enable.Size = new System.Drawing.Size(176, 16);
            this.checkBox_ICodeUID_Enable.TabIndex = 0;
            this.checkBox_ICodeUID_Enable.Text = "I-Code UID";
            this.checkBox_ICodeUID_Enable.CheckStateChanged += new System.EventHandler(this.checkBox_ICodeUID_Enable_CheckStateChanged);
            // 
            // checkBox_ARIO_Enable
            // 
            this.checkBox_ARIO_Enable.Checked = true;
            this.checkBox_ARIO_Enable.CheckState = System.Windows.Forms.CheckState.Checked;
            this.checkBox_ARIO_Enable.Location = new System.Drawing.Point(8, 84);
            this.checkBox_ARIO_Enable.Name = "checkBox_ARIO_Enable";
            this.checkBox_ARIO_Enable.Size = new System.Drawing.Size(176, 16);
            this.checkBox_ARIO_Enable.TabIndex = 1;
            this.checkBox_ARIO_Enable.Text = "ARIO ReadOnly / FDX-B";
            this.checkBox_ARIO_Enable.CheckStateChanged += new System.EventHandler(this.checkBox_ARIO_Enabled_CheckStateChanged);
            // 
            // checkBox_iIDG_Enable
            // 
            this.checkBox_iIDG_Enable.Checked = true;
            this.checkBox_iIDG_Enable.CheckState = System.Windows.Forms.CheckState.Checked;
            this.checkBox_iIDG_Enable.Location = new System.Drawing.Point(8, 65);
            this.checkBox_iIDG_Enable.Name = "checkBox_iIDG_Enable";
            this.checkBox_iIDG_Enable.Size = new System.Drawing.Size(176, 16);
            this.checkBox_iIDG_Enable.TabIndex = 2;
            this.checkBox_iIDG_Enable.Text = "iID-G system";
            this.checkBox_iIDG_Enable.CheckStateChanged += new System.EventHandler(this.checkBox_iIDG_Enabled_CheckStateChanged);
            // 
            // checkBox_iIDD_Enable
            // 
            this.checkBox_iIDD_Enable.Checked = true;
            this.checkBox_iIDD_Enable.CheckState = System.Windows.Forms.CheckState.Checked;
            this.checkBox_iIDD_Enable.Location = new System.Drawing.Point(8, 46);
            this.checkBox_iIDD_Enable.Name = "checkBox_iIDD_Enable";
            this.checkBox_iIDD_Enable.Size = new System.Drawing.Size(176, 16);
            this.checkBox_iIDD_Enable.TabIndex = 3;
            this.checkBox_iIDD_Enable.Text = "iID-D / PSK1,2 system";
            this.checkBox_iIDD_Enable.CheckStateChanged += new System.EventHandler(this.checkBox_iIDD_Enabled_CheckStateChanged);
            // 
            // checkBox_ICode1_Enable
            // 
            this.checkBox_ICode1_Enable.Checked = true;
            this.checkBox_ICode1_Enable.CheckState = System.Windows.Forms.CheckState.Checked;
            this.checkBox_ICode1_Enable.Location = new System.Drawing.Point(8, 27);
            this.checkBox_ICode1_Enable.Name = "checkBox_ICode1_Enable";
            this.checkBox_ICode1_Enable.Size = new System.Drawing.Size(176, 16);
            this.checkBox_ICode1_Enable.TabIndex = 4;
            this.checkBox_ICode1_Enable.Text = "I-Code 1 / TITAN system";
            this.checkBox_ICode1_Enable.CheckStateChanged += new System.EventHandler(this.checkBox_ICode1_Enable_CheckStateChanged);
            // 
            // checkBox_ISO15693_Enable
            // 
            this.checkBox_ISO15693_Enable.Checked = true;
            this.checkBox_ISO15693_Enable.CheckState = System.Windows.Forms.CheckState.Checked;
            this.checkBox_ISO15693_Enable.Location = new System.Drawing.Point(8, 8);
            this.checkBox_ISO15693_Enable.Name = "checkBox_ISO15693_Enable";
            this.checkBox_ISO15693_Enable.Size = new System.Drawing.Size(176, 16);
            this.checkBox_ISO15693_Enable.TabIndex = 5;
            this.checkBox_ISO15693_Enable.Text = "ISO15693 / UNIQUE system";
            this.checkBox_ISO15693_Enable.CheckStateChanged += new System.EventHandler(this.checkBox_ISO15693_Enable_CheckStateChanged);
            // 
            // Timer_Scan
            // 
            this.Timer_Scan.Tick += new System.EventHandler(this.Timer_Scan_Tick);
            // 
            // Timer_CheckReader
            // 
            this.Timer_CheckReader.Interval = 5000;
            this.Timer_CheckReader.Tick += new System.EventHandler(this.Timer_CheckReader_Tick);
            // 
            // progressBar
            // 
            this.progressBar.Location = new System.Drawing.Point(0, 232);
            this.progressBar.Maximum = 10;
            this.progressBar.Name = "progressBar";
            this.progressBar.Size = new System.Drawing.Size(232, 8);
            // 
            // Timer_ReadText
            // 
            this.Timer_ReadText.Tick += new System.EventHandler(this.Timer_ReadText_Tick);
            // 
            // Timer_WriteText
            // 
            this.Timer_WriteText.Tick += new System.EventHandler(this.Timer_WriteText_Tick);
            // 
            // Form_Main
            // 
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Inherit;
            this.ClientSize = new System.Drawing.Size(638, 455);
            this.Controls.Add(this.progressBar);
            this.Controls.Add(this.StatusBar_Main);
            this.Controls.Add(this.tabControl_Main);
            this.Location = new System.Drawing.Point(0, 0);
            this.Menu = this.mainMenu;
            this.MinimizeBox = false;
            this.Name = "Form_Main";
            this.Text = "C# sample code iID(R) driver";
            this.WindowState = System.Windows.Forms.FormWindowState.Maximized;
            this.Closing += new System.ComponentModel.CancelEventHandler(this.Form_Main_Closing);
            this.Load += new System.EventHandler(this.Form_Main_Load);
            this.tabControl_Main.ResumeLayout(false);
            this.tabPage_Identify.ResumeLayout(false);
            this.tabPage_TextDemo.ResumeLayout(false);
            this.tabPage_Settings.ResumeLayout(false);
            this.panel_System.ResumeLayout(false);
            this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>

		static void Main() 
		{
			Application.Run(new Form_Main());
		}
																	
		private void InitializeInterface(object sender)
		{
			Timer_CheckReader.Enabled=false;
			UncheckMenues();
			Reader.Reader_CloseInterface();
			StatusBar_Main.Text="Port NOT initialized!";
			Reader.PortName=(sender as MenuItem).Text;
			Reader.Reader_OpenInterface();
			if (Reader.Port_Initialized==0) return;
			if (Reader.Reader_Connected==1)
			{
				Strg=String.Format("READER ID {0}, driver ver {1}.{2} initialized.", Reader.Reader_Id, Reader.Version_Main_Driver_Engine, Reader.Version_Sub_Driver_Engine);					
				StatusBar_Main.Text=Strg;
				CommonF.SuccessBeep();
			}
			else
			{
				StatusBar_Main.Text=String.Format("No READER connected, driver ver {0}.{1} initialized.", Reader.Version_Main_Driver_Engine, Reader.Version_Sub_Driver_Engine);					
			}
			Timer_CheckReader.Enabled=true;
			(sender as MenuItem).Checked=true;
		}
		

		private void Form_Main_Load(object sender, System.EventArgs e)
		{
		}


		private void button_Cancel_Click(object sender, System.EventArgs e)
		{
			cancelread=true;
		}

		private void Timer_CheckReader_Tick(object sender, System.EventArgs e)
		{
            Reader.Reader_GetState();
            if ((Reader.Port_Initialized == 1) && (Reader.Reader_Connected == 1))
            {
                //Okay, Reader connected
                StatusBar_Main.Text = String.Format("Reader ID {0}, driver ver {1}.{2} present.", Reader.Reader_Id, Reader.Version_Main_Driver_Engine, Reader.Version_Sub_Driver_Engine);
                StatusBar_Main.Refresh();
                return;
            }
            if (Reader.Port_Initialized == 0)
            {
                //Port not valid, try to re-initialize
                StatusBar_Main.Text = "Port not valid!";
                Reader.Reader_CloseInterface();
                Reader.Reader_OpenInterface();
                if (Reader.Port_Initialized == 1)
                {
                    StatusBar_Main.Text = "Port re-initialized!";
                }
            }
            else
            {
                //Reader not detected, try to re-initialize
                StatusBar_Main.Text = String.Format("No Reader connected, driver ver {0}.{1} ready.", Reader.Version_Main_Driver_Engine, Reader.Version_Sub_Driver_Engine);
            }
            StatusBar_Main.Refresh();           
		}

		private void tabControl_Main_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//Abort TAG operations, when leaving active page
			cancelread=true;
			panel_ReadWrite.BackColor=tabPage_TextDemo.BackColor;
		}



		private void Form_Main_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			this.Dispose(true);
		}

		
		#region "Registerkarte IDENTIFY und zugehrige Vorgnge"

		private void button_ReadTag_Click(object sender, System.EventArgs e)
		{
			listBox_UID.Items.Clear();
			cancelread=false;
			Timer_Scan.Enabled=true;
		}

		private void Timer_Scan_Tick(object sender, System.EventArgs e)
		{
			if (progressBar.Value==progressBar.Maximum) progressBar.Value=progressBar.Minimum;
			progressBar.Value++;
			this.Refresh();

			if (cancelread)
			{
				//Abort reading the TAG
				progressBar.Value=0;
				Timer_Scan.Enabled=false;
			}

			//Read Identifiers of all known transponders
			ergeb=Reader.Reader_Identify();
			if (ergeb==0)
			{				
				//Identifier found, bring into listbox
				if (checkBox_FilterUID.Checked)
				{
					if (OLD_UIDText==Reader.UIDText) return;
				}
				listBox_UID.Items.Add(Reader.UIDText);
				OLD_UIDText=Reader.UIDText;
				listBox_UID.SelectedIndex=listBox_UID.Items.Count-1;
				CommonF.SuccessBeep();
			}
		}
		#endregion

		#region "Registerkarte TEXTDEMO und zugehrige Vorgnge"
		private void button_ReadText_Click(object sender, System.EventArgs e)
		{
			panel_ReadWrite.BackColor=Color.Red;
			Edit_TextDemo.Text="";
			cancelread=false;
			Timer_ReadText.Enabled=true;
		}

		private void button_CancelText_Click(object sender, System.EventArgs e)
		{
			cancelread=true;
			Edit_TextDemo.Text="";
			panel_ReadWrite.BackColor=tabPage_TextDemo.BackColor;
		}

		private void Timer_ReadText_Tick(object sender, System.EventArgs e)
		{		
			if (progressBar.Value==progressBar.Maximum) progressBar.Value=progressBar.Minimum;
			progressBar.Value++;
			this.Refresh();

			if (cancelread)
			{
				//Abort reading the TAG
				progressBar.Value=0;
				Timer_ReadText.Enabled=false;
				return;
			}

			//Read UID at first
			ergeb=Reader.Reader_Identify();
			if (ergeb==0)
			{				
				//TAG found
				panel_ReadWrite.BackColor=Color.LightGreen;
				this.Refresh();

				Reader.From=0;
                //2007-01 - c_get_transponder_parameters return max. available TAG space
                Reader.Length=Edit_TextDemo.MaxLength;
				if (Reader.Length > Reader.TagMaxLength) Reader.Length=Reader.TagMaxLength;

                StatusBar_Main.Text = String.Format("Transferring {0} bytes...", Reader.Length); StatusBar_Main.Refresh();
				ergeb=Reader.Reader_ReadBytes();
				if (ergeb==0) 
				{
					CommonF.SuccessBeep();
					cancelread=true;
					i=0;
					Strg="";
					while(i<Reader.Length)
					{
						if(Reader.Read_Array[i+1]==0) break;
						Strg=Strg+Convert.ToChar(Reader.Read_Array[i+1]);
						i++;
					}
					Edit_TextDemo.Text=Strg;
					panel_ReadWrite.BackColor=tabPage_TextDemo.BackColor;
					this.Refresh();
					return;
				}
				else
					panel_ReadWrite.BackColor=Color.Red;
			}
			else
				panel_ReadWrite.BackColor=Color.Red;
		}

		private void Timer_WriteText_Tick(object sender, System.EventArgs e)
		{
			if (progressBar.Value==progressBar.Maximum) progressBar.Value=progressBar.Minimum;
			progressBar.Value++;
			this.Refresh();

			if (cancelread)
			{
				//Abort reading the TAG
				progressBar.Value=0;
				Timer_WriteText.Enabled=false;
				return;
			}

			//Read UID at first
			ergeb=Reader.Reader_Identify();
			if (ergeb==0)
			{				
				panel_ReadWrite.BackColor=Color.LightGreen;
				this.Refresh();
				//TAG found
				Reader.From=0;
                //2007-01 - c_get_transponder_parameters return max. available TAG space
                Reader.Length = Edit_TextDemo.MaxLength;
                if (Reader.Length > Reader.TagMaxLength) Reader.Length=Reader.TagMaxLength;

                StatusBar_Main.Text = String.Format("Transferring {0} bytes...", Reader.Length); StatusBar_Main.Refresh();
                ergeb = Reader.Reader_WriteBytes();
				if (ergeb==0) 
				{
					CommonF.SuccessBeep();
					cancelread=true;
					panel_ReadWrite.BackColor=tabPage_TextDemo.BackColor;
					return;
				}
				else
					panel_ReadWrite.BackColor=Color.Red;
			}
			else
				panel_ReadWrite.BackColor=Color.Red;

		}

		private void button_WriteText_Click(object sender, System.EventArgs e)
		{
			panel_ReadWrite.BackColor=Color.Red;
			cancelread=false;
			for (i=0;i<Edit_TextDemo.MaxLength;i++) Reader.Write_Array[i]=0;
			for (i=0;i<Edit_TextDemo.TextLength;i++)
			{
				Reader.Write_Array[i]=Convert.ToByte(Edit_TextDemo.Text[i]);
			}
			Timer_WriteText.Enabled=true;
		}
		#endregion

		#region "Menuitems und zugehrige Vorgnge"

		private void menuItem_COM1_Click(object sender, System.EventArgs e)
		{
			InitializeInterface(sender);
		}

		private void menuItem_COM2_Click(object sender, System.EventArgs e)
		{
			InitializeInterface(sender);
		}

		private void menuItem_COM3_Click(object sender, System.EventArgs e)
		{
			InitializeInterface(sender);
		}

		private void menuItem_COM4_Click(object sender, System.EventArgs e)
		{
			InitializeInterface(sender);
		}

		private void menuItem_COM5_Click(object sender, System.EventArgs e)
		{
			InitializeInterface(sender);
		}

		private void menuItem_COM6_Click(object sender, System.EventArgs e)
		{
			InitializeInterface(sender);
		}

		private void menuItem_COM7_Click(object sender, System.EventArgs e)
		{
			InitializeInterface(sender);
		}

		private void menuItem_COM8_Click(object sender, System.EventArgs e)
		{
			InitializeInterface(sender);
		}

		private void UncheckMenues()
		{
			menuItem_COM1.Checked=false;
			menuItem_COM2.Checked=false;
			menuItem_COM3.Checked=false;
			menuItem_COM4.Checked=false;
			menuItem_COM5.Checked=false;
			menuItem_COM6.Checked=false;
			menuItem_COM7.Checked=false;
			menuItem_COM8.Checked=false;
			menuItem_COM9.Checked=false;
			menuItem_COM10.Checked=false;
			menuItem_COM11.Checked=false;
			menuItem_COM12.Checked=false;
			menuItem_COM13.Checked=false;
			menuItem_COM14.Checked=false;
		}

		private void menuItem_pen_mem_Click(object sender, System.EventArgs e)
		{
			menuItem_125.Checked=false;
			menuItem_1356.Checked=false;
			menuItem_pen_mem.Checked=true;
			//neu eingefhrt, MEM-Interface bekommt 0x10 als InterfaceType
			Reader.InterfaceType=0x10;	
		}

		private void menuItem_About_Click(object sender, System.EventArgs e)
		{
			MessageBox.Show("MICROSENSYS RFID .Net sample code (C#/VS.Net2005) V2006-Apr","Information");
		}


		private void menuItem_Serial_Click(object sender, System.EventArgs e)
		{
			menuItem_BLUESPP.Checked=false;
			menuItem_Serial.Checked=false;
			menuItem_CF.Checked=false;
			menuItem_USB.Checked=false;
			menuItem_Serial.Checked=true;Reader.PortType=0;
		}

		private void menuItem_BLUESPP_Click(object sender, System.EventArgs e)
		{
			menuItem_BLUESPP.Checked=false;
			menuItem_Serial.Checked=false;
			menuItem_CF.Checked=false;
			menuItem_USB.Checked=false;
			menuItem_BLUESPP.Checked=true;Reader.PortType=2;
		}

		private void menuItem_CF_Click(object sender, System.EventArgs e)
		{
			menuItem_BLUESPP.Checked=false;
			menuItem_Serial.Checked=false;
			menuItem_CF.Checked=false;
			menuItem_USB.Checked=false;
			menuItem_CF.Checked=true;Reader.PortType=1;
		}

		private void menuItem_1356_Click(object sender, System.EventArgs e)
		{
			menuItem_125.Checked=false;
			menuItem_pen_mem.Checked=false;
			menuItem_1356.Checked=true;
			Reader.InterfaceType=1356;
		}

		private void menuItem125_Click(object sender, System.EventArgs e)
		{
			menuItem_125.Checked=true;
			menuItem_1356.Checked=false;
			menuItem_pen_mem.Checked=false;
			Reader.InterfaceType=125;	
		}

		private void menuItem_COM9_Click(object sender, System.EventArgs e)
		{
			InitializeInterface(sender);
		}

		private void menuItem_COM10_Click(object sender, System.EventArgs e)
		{
			InitializeInterface(sender);		
		}

		private void menuItem_COM11_Click(object sender, System.EventArgs e)
		{
			InitializeInterface(sender);
		}

		private void menuItem_COM12_Click(object sender, System.EventArgs e)
		{
			InitializeInterface(sender);
		}

		private void menuItem_COM13_Click(object sender, System.EventArgs e)
		{
			InitializeInterface(sender);
		}

		private void menuItem_COM14_Click(object sender, System.EventArgs e)
		{
			InitializeInterface(sender);
		}

		private void menuItem_USB_Click(object sender, System.EventArgs e)
		{
			menuItem_BLUESPP.Checked=false;
			menuItem_Serial.Checked=false;
			menuItem_CF.Checked=false;
			menuItem_USB.Checked=false;
			menuItem_USB.Checked=true;Reader.PortType=4;
		}
		#endregion

		#region "Settings-Seite und zugehrige Vorgnge"

		private void checkBox_ISO15693_Enable_CheckStateChanged(object sender, System.EventArgs e)
		{
			if (checkBox_ISO15693_Enable.Checked) Reader.DriverSystemMask=Reader.DriverSystemMask | 0x01; else Reader.DriverSystemMask=Reader.DriverSystemMask & 0xFE;
			Reader.Driver_SetParameters();
		}

		private void checkBox_ICode1_Enable_CheckStateChanged(object sender, System.EventArgs e)
		{
			if (checkBox_ICode1_Enable.Checked) Reader.DriverSystemMask=Reader.DriverSystemMask | 0x02; else Reader.DriverSystemMask=Reader.DriverSystemMask & 0xFD;		
			Reader.Driver_SetParameters();
		}

		private void checkBox_iIDD_Enabled_CheckStateChanged(object sender, System.EventArgs e)
		{
			if (checkBox_iIDD_Enable.Checked) Reader.DriverSystemMask=Reader.DriverSystemMask | 0x04; else Reader.DriverSystemMask=Reader.DriverSystemMask & 0xFB;		
			Reader.Driver_SetParameters();
		}

		private void checkBox_iIDG_Enabled_CheckStateChanged(object sender, System.EventArgs e)
		{
			if (checkBox_iIDG_Enable.Checked) Reader.DriverSystemMask=Reader.DriverSystemMask | 0x08; else Reader.DriverSystemMask=Reader.DriverSystemMask & 0xF7;
			Reader.Driver_SetParameters();
		}

		private void checkBox_ARIO_Enabled_CheckStateChanged(object sender, System.EventArgs e)
		{
			if (checkBox_ARIO_Enable.Checked) Reader.DriverSystemMask=Reader.DriverSystemMask | 0x10; else Reader.DriverSystemMask=Reader.DriverSystemMask & 0xEF;		
			Reader.Driver_SetParameters();
		}

		private void numericUpDown_Timeout_ValueChanged(object sender, System.EventArgs e)
		{
			Reader.DriverTimeOut=Convert.ToInt32(numericUpDown_Timeout.Value);
			Reader.Driver_SetParameters();
		}

		private void checkBox_ICodeUID_Enable_CheckStateChanged(object sender, System.EventArgs e)
		{
			if (checkBox_ICodeUID_Enable.Checked) Reader.DriverSystemMask=Reader.DriverSystemMask | 0x20; else Reader.DriverSystemMask=Reader.DriverSystemMask & 0xDF;
			Reader.Driver_SetParameters();
		}
		#endregion


        private void menuItem_Quit_Click(object sender, EventArgs e)
        {
            this.Close();
        }


	}
}
