unit ik121_unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  ik121_baseunit, Buttons, ExtCtrls;

type
  TParameters = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    period1: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    strichzahl1: TEdit;
    digits1: TEdit;
    resolution1: TEdit;
    x_ref_1_pan: TPanel;
    x_ref_2_pan: TPanel;
    x_ref_3_pan: TPanel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    x_sys_1_pan: TPanel;
    x_sys_2_pan: TPanel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    x_inv_1_pan: TPanel;
    Label7: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    minbound: TEdit;
    maxbound: TEdit;
    minmax_1_pan: TPanel;
    minmax_2_pan: TPanel;
    Label18: TLabel;
    Label21: TLabel;
    setup_ok: TBitBtn;
    para_def: TButton;
    para_save: TButton;
    para_load: TButton;
    BitBtn1: TBitBtn;
    Label8: TLabel;
    distance: TEdit;
    axis: TPanel;
    Panel1: TPanel;
    Panel2: TPanel;

    procedure resolution1Change(Sender: TObject);
    procedure period1Change(Sender: TObject);
    procedure strichzahl1Change(Sender: TObject);
    procedure digits1Change(Sender: TObject);
    procedure x_ref_1_panClick(Sender: TObject);
    procedure x_ref_2_panClick(Sender: TObject);
    procedure x_ref_3_panClick(Sender: TObject);
    procedure x_sys_2_panClick(Sender: TObject);
    procedure x_sys_1_panClick(Sender: TObject);
    procedure x_inv_1_panClick(Sender: TObject);
    procedure setup_okClick(Sender: TObject);
    procedure para_defClick(Sender: TObject);
    procedure para_saveClick(Sender: TObject);
    procedure para_loadClick(Sender: TObject);
    procedure minmax_1_panClick(Sender: TObject);
    procedure minmax_2_panClick(Sender: TObject);
    procedure minboundChange(Sender: TObject);
    procedure maxboundChange(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure distanceChange(Sender: TObject);
    procedure axisClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

procedure rebuild_para(count:count_pointr);

var
  Parameters: TParameters;

implementation

uses ik121_unit1;

{$R *.DFM}

(*************************************************)
(*************************************************)
 procedure rebuild_para(count:count_pointr);
 var
  s   : string;
  i   : integer;
  r   : real;
  x,d : byte;
 begin

  x:=count^.axis;

  (* Display axis *)

  str(x,s);
  parameters.axis.caption:=s;

  (* Resolution *)

  i:=count^.count[x]^.resolution;
  str(i,s);
  Parameters.resolution1.text:=s;

   (* Period *)

  i:=count^.count[x]^.period;
  str(i,s);
  parameters.period1.text:=s;
  (* Digits *)

  i:=count^.count[x]^.digits;
  str(i,s);
  parameters.digits1.text:=s;

  (* Ref. marks *)

  if count^.count[x]^.refmark=no then
    begin
      parameters.x_ref_1_pan.caption:='X';
    end
  else
    begin
      parameters.x_ref_1_pan.caption:='';
    end;

  if count^.count[x]^.refmark=one then
    begin
      parameters.x_ref_2_pan.caption:='X';
    end
  else
    begin
      parameters.x_ref_2_pan.caption:='';
    end;

  if count^.count[x]^.refmark=coded then
    begin
      parameters.x_ref_3_pan.caption:='X';
    end
  else
    begin
      parameters.x_ref_3_pan.caption:='';
    end;

  i:=count^.count[x]^.distance;
  str(i,s);
  parameters.distance.text:=s;

  (* Linear, rotary *)

  if count^.count[x]^.system=linear then
    begin
      parameters.x_sys_1_pan.caption:='X';
    end
  else
    begin
      parameters.x_sys_1_pan.caption:='';
    end;

  if count^.count[x]^.system=rotary then
    begin
      parameters.x_sys_2_pan.caption:='X';
    end
  else
    begin
      parameters.x_sys_2_pan.caption:='';
    end;

 (* Rotary: periods/rotation axis X *)

  i:=count^.count[x]^.strichzahl;
  str(i,s);
  parameters.strichzahl1.text:=s;

 (* Direction *)

  if count^.count[x]^.direction=normal then
    begin
      parameters.x_inv_1_pan.caption:='';
    end
  else
    begin
      parameters.x_inv_1_pan.caption:='X';
    end;

  (* Min/Max *)

  if count^.count[x]^.minmode then
    begin
      parameters.minmax_1_pan.caption:='X';
    end
  else
    begin
      parameters.minmax_1_pan.caption:='';
    end;
  if count^.count[x]^.maxmode then
    begin
      parameters.minmax_2_pan.caption:='X';
    end
  else
    begin
      parameters.minmax_2_pan.caption:='';
    end;

  (* Sorting *)

  d:=count^.count[x]^.digits;

  r:=count^.count[x]^.minbound;
  str(r:5:d,s);
  parameters.minbound.text:=s;

  r:=count^.count[x]^.maxbound;
  str(r:5:d,s);
  parameters.maxbound.text:=s;

 end;
(*************************************************)
(*************************************************)
procedure TParameters.FormActivate(Sender: TObject);
begin
  rebuild_para(count);
end;
(*************************************************)
(*************************************************)
procedure TParameters.axisClick(Sender: TObject);
begin
  count^.axis:=count^.axis+1;
  if count^.axis>count^.axisnumber then
    begin
      count^.axis:=0;
    end;
  rebuild_para(count);
end;
(*************************************************)
(*************************************************)
procedure TParameters.resolution1Change(Sender: TObject);
var
  s      : string;
  i,code : integer;
  x      : byte;
begin
  x:=count^.axis;
  s:=parameters.resolution1.text;
  val(s,i,code);
  if i<=0 then i:=1;
  count^.count[x]^.resolution:=i;
end;
(*************************************************)
(*************************************************)
procedure TParameters.period1Change(Sender: TObject);
var
  s      : string;
  i,code : integer;
  x      : byte;
begin
  x:=count^.axis;
  s:=parameters.period1.text;
  val(s,i,code);
  if i<=0 then i:=1;
  count^.count[x]^.period:=i;
end;
(*************************************************)
(*************************************************)
procedure TParameters.digits1Change(Sender: TObject);
var
  s      : string;
  i,code : integer;
  x      : byte;
begin
  x:=count^.axis;
  s:=parameters.digits1.text;
  val(s,i,code);
  if i>6 then i:=6;
  if i<0 then i:=0;
  count^.count[x]^.digits:=i;
end;
(*************************************************)
(* Reference pulse selection                     *)
(*************************************************)
procedure TParameters.x_ref_1_panClick(Sender: TObject);
var
  x      : byte;
begin
  x:=count^.axis;
  parameters.x_ref_1_pan.caption:='X';
  parameters.x_ref_2_pan.caption:='';
  parameters.x_ref_3_pan.caption:='';
  count^.count[x]^.refmark:=no;
end;
(*************************************************)
(*************************************************)
procedure TParameters.x_ref_2_panClick(Sender: TObject);
var
  x      : byte;
begin
  x:=count^.axis;
  parameters.x_ref_1_pan.caption:='';
  parameters.x_ref_2_pan.caption:='X';
  parameters.x_ref_3_pan.caption:='';
  count^.count[x]^.refmark:=one;
end;
(*************************************************)
(*************************************************)
procedure TParameters.x_ref_3_panClick(Sender: TObject);
var
  x      : byte;
begin
  x:=count^.axis;
  parameters.x_ref_1_pan.caption:='';
  parameters.x_ref_2_pan.caption:='';
  parameters.x_ref_3_pan.caption:='X';
  count^.count[x]^.refmark:=coded;
end;
(*************************************************)
(*************************************************)
procedure TParameters.x_sys_1_panClick(Sender: TObject);
var
  x      : byte;
begin
  x:=count^.axis;
  parameters.x_sys_1_pan.caption:='X';
  parameters.x_sys_2_pan.caption:='';
  count^.count[x]^.system:=linear;
end;
(*************************************************)
(*************************************************)
procedure TParameters.x_sys_2_panClick(Sender: TObject);
var
  x      : byte;
begin
  x:=count^.axis;
  parameters.x_sys_1_pan.caption:='';
  parameters.x_sys_2_pan.caption:='X';
  count^.count[x]^.system:=rotary;
end;
(*************************************************)
(*************************************************)
procedure TParameters.strichzahl1Change(Sender: TObject);
var
  s      : string;
  i,code : integer;
  x      : byte;
begin
  x:=count^.axis;
  s:=parameters.strichzahl1.text;
  val(s,i,code);
  if i<=0 then i:=1;
  count^.count[x]^.strichzahl:=i;
end;
(*************************************************)
(*************************************************)
procedure TParameters.x_inv_1_panClick(Sender: TObject);
var
  x      : byte;
begin
  x:=count^.axis;
  if count^.count[x]^.direction=normal then
    begin
      count^.count[x]^.direction:=inverted;
      parameters.x_inv_1_pan.caption:='X';
    end
  else
    begin
      count^.count[x]^.direction:=normal;
      parameters.x_inv_1_pan.caption:='';
    end;
end;
(*************************************************)
(*************************************************)
procedure TParameters.setup_okClick(Sender: TObject);
begin
      parameters.Hide;
end;
(*************************************************)
(*************************************************)
procedure TParameters.para_defClick(Sender: TObject);
begin
      init_counter(count);
      rebuild_para(count);
end;
(*************************************************)
(* Ik121.cnt write                               *)
(*************************************************)
procedure TParameters.para_saveClick(Sender: TObject);
begin
      write_csetup(count);
end;
(*************************************************)
(*************************************************)
procedure TParameters.para_loadClick(Sender: TObject);
begin
      read_csetup(count);
      rebuild_para(count);
end;
(*************************************************)
(*************************************************)
procedure TParameters.minmax_1_panClick(Sender: TObject);
var
  x      : byte;
begin
      x:=count^.axis;
      if not(count^.count[x]^.minmode) then
        begin
          parameters.minmax_1_pan.caption:='X';
          parameters.minmax_2_pan.caption:='';
          count^.count[x]^.minmode:=true;
          count^.count[x]^.maxmode:=false;
          count^.count[x]^.minwert:=count^.count[x]^.awert;
        end
      else
        begin
          parameters.minmax_1_pan.caption:='';
          parameters.minmax_2_pan.caption:='';
          count^.count[x]^.minmode:=false;
          count^.count[x]^.maxmode:=false;
        end;
      rebuild_para(count);
end;
(*************************************************)
(*************************************************)
procedure TParameters.minmax_2_panClick(Sender: TObject);
var
  x      : byte;
begin
      x:=count^.axis;
      if not(count^.count[x]^.maxmode) then
        begin
          parameters.minmax_1_pan.caption:='';
          parameters.minmax_2_pan.caption:='X';
          count^.count[x]^.minmode:=false;
          count^.count[x]^.maxmode:=true;
          count^.count[x]^.maxwert:=count^.count[x]^.awert;
        end
      else
        begin
          parameters.minmax_1_pan.caption:='';
          parameters.minmax_2_pan.caption:='';
          count^.count[x]^.minmode:=false;
          count^.count[x]^.maxmode:=false;
        end;
      rebuild_para(count);
end;
(*************************************************)
(*************************************************)
procedure TParameters.minboundChange(Sender: TObject);
var
  s      : string;
  code   : integer;
  x      : byte;
  r      : real;
begin
  x:=count^.axis;
  s:=parameters.minbound.text;
  val(s,r,code);
  count^.count[x]^.minbound:=r;
end;
(*************************************************)
(*************************************************)
procedure TParameters.maxboundChange(Sender: TObject);
var
  s      : string;
  code   : integer;
  x      : byte;
  r      : real;
begin
  x:=count^.axis;
  s:=parameters.maxbound.text;
  val(s,r,code);
  count^.count[x]^.maxbound:=r;
end;
(*************************************************)
(*************************************************)
procedure TParameters.BitBtn1Click(Sender: TObject);
begin
  Parameters.hide;
end;
(*************************************************)
(*************************************************)
procedure TParameters.distanceChange(Sender: TObject);
var
  s      : string;
  i,code : integer;
  x      : byte;
begin
  x:=count^.axis;
  s:=parameters.distance.text;
  val(s,i,code);
  count^.count[x]^.distance:=i;
end;
(*************************************************)
(*************************************************)
end.
