program sample3;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Measure Speed on Axis 1                               }
{                                                       }
{ V 1.00                                                }
{ July 1994                                             }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

uses crt,dos,ik121_0,ik121_1;

var
  board : ik121_pointr;
  axis1,axis2 : g26_pointr;
(*________________________________________*)
procedure geschwindigkeit;
var ende : boolean;
    a,diff,altdiff,wert,altwert,uraltwert: comp;
begin
  (* Only axis1 is measured *)

  board^.axis[1]^.timer:=999;
  board^.axis[1]^.inimain.mode1024:=true;
  board^.axis[1]^.inimain.en_timer:=true;
  board^.axis[1]^.softcomm.start:=true;
  board^.axis[1]^.softcomm.clear:=true;
  board^.axis[1]^.softcomm.clrfreq:=true;
  board^.axis[1]^.softcomm.clrstat:=true;
  board^.axis[1]^.inilatch.en_timer_reg1:=true;
  Init_Handler(board^.axis[1]);
  Comm_Handler(board^.axis[1]);

  gotoxy(40,20);
  writeln('Press any key!');
  textcolor(4);
  repeat
      (* Read old value first !!! *)
      repeat
      until Latched(board^.axis[1]^.baseadr,board^.axis[1]^.axis,1);
      uraltwert:=Read_Count_value48(board^.axis[1]^.baseadr,board^.axis[1]^.axis,1,false);

      (* Read first value *)
      repeat
      until Latched(board^.axis[1]^.baseadr,board^.axis[1]^.axis,1);
      uraltwert:=Read_Count_value48(board^.axis[1]^.baseadr,board^.axis[1]^.axis,1,false);

      (* Read second value *)
      repeat
      until Latched(board^.axis[1]^.baseadr,board^.axis[1]^.axis,1);
      altwert:=Read_Count_value48(board^.axis[1]^.baseadr,board^.axis[1]^.axis,1,false);

      (* Read third value *)
      repeat
      until Latched(board^.axis[1]^.baseadr,board^.axis[1]^.axis,1);
      wert:=Read_Count_value48(board^.axis[1]^.baseadr,board^.axis[1]^.axis,1,false);

      altdiff:=altwert-uraltwert;
      diff:=wert-altwert;
      a:=diff-altdiff;

      gotoxy(1,10);
      writeln(' Speed        ds(1) : ',altdiff:10:0,'        ');
      writeln(' Speed        ds(2) : ',diff:10:0,'        ');
      writeln(' Acceleration dv    : ',a:10:0,'        ');

      if (a>100) or (a<-100) then
        begin
          writeln('a>100');
          sound(400);
          delay(50);
          nosound;
        end
      else
        begin
          writeln('     ');
        end;

  until keypressed;
end;
(*________________________________________*)
begin
  textbackground(7);
  clrscr;
  textcolor(15);
  New(board);
  New(axis1);
  New(axis2);
  board^.axis[1]:=axis1;
  board^.axis[2]:=axis2;
  init_ik121(board);
  if look_for_ik121(board) then
    begin
      geschwindigkeit
    end
  else
    begin
      clrscr;
      write('No hardware!!');
      readln;
    end;
  Dispose(axis1);
  Dispose(axis2);
  Dispose(board);
  textbackground(0);
  clrscr;
end.