program potis;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Manual Adjustment of EEPROM Pots                      }
{                                                       }
{ V 1.00                                                }
{ July 1994                                             }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

uses crt,graph,logo,ik121_1,cnt_0,poti_0;

var
  board                 : ik121_pointr;
  axis1,axis2           : g26_pointr;
  graphmode,graphdriver : integer;
  xmax,ymax             : word;


begin
  clrscr;
  jh_logo;
  delay(2000);
  closegraph;
  graphdriver:=detect;
  initgraph(graphdriver,graphmode,'');
  New(board);
  New(axis1);
  New(axis2);
  board^.axis[1]:=axis1;
  board^.axis[2]:=axis2;
  init_ik121(board);
  if look_for_ik121(board) then
    begin
      turnpotis(board);
      closegraph;
    end
  else
    begin
      closegraph;
      clrscr;
      writeln('No Hardware!!');
      readln;
    end;
  Dispose(board);
  Dispose(axis1);
  Dispose(axis2);
end.
(*________________________________________*)