UNIT ik121_2;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Driver Unit for ADJUST.EXE, POTIS.EXE and SCOPE.EXE   }
{                                                       }
{ V 1.00                                                }
{ July 1994                                             }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

interface

uses graph,ik121_0,ik121_1;

type
   single_pointr = ^singleshot;
   singleshot = record
                  dg00 : word;
                  dg90 : word;
                  intp : word;
                  next : single_pointr;
                end;

procedure init_analyze(board:ik121_pointr);
procedure get_single(axis:g26_pointr;var samp : single_pointr);
procedure build_sample(var samp:single_pointr);
procedure get_sample(axis:g26_pointr;samp:single_pointr);
procedure free_sample(samp:single_pointr);

Implementation
{----------------------------------------------------------}
procedure init_analyze(board:ik121_pointr);
BEGIN
  (* Axis 1 *)

  board^.axis[1]^.timer:=$00FF;
  board^.axis[1]^.inimain.mode1024:=true;
  board^.axis[1]^.inimain.en_timer:=true;
  board^.axis[1]^.inilatch.en_timer_reg1:=true;
  board^.axis[1]^.softcomm.start:=true;
  board^.axis[1]^.softcomm.clear:=true;
  board^.axis[1]^.softcomm.clrfreq:=true;
  board^.axis[1]^.softcomm.clrstat:=true;

  (* Axis 2 *)

  board^.axis[2]^.timer:=$00FF;
  board^.axis[2]^.inimain.mode1024:=true;
  board^.axis[2]^.inimain.en_timer:=true;
  board^.axis[2]^.inilatch.en_timer_reg1:=true;
  board^.axis[2]^.softcomm.start:=true;
  board^.axis[2]^.softcomm.clear:=true;
  board^.axis[2]^.softcomm.clrfreq:=true;
  board^.axis[2]^.softcomm.clrstat:=true;

  Init_Handler(board^.axis[1]);
  Init_Handler(board^.axis[2]);
  Comm_Handler(board^.axis[1]);
  Comm_Handler(board^.axis[2]);
END;
{----------------------------------------------------------}
procedure get_single(axis:g26_pointr;var samp : single_pointr);
var
  wert : word;
  dummy : word;
BEGIN
  repeat
  until ((read_g26(axis^.baseadr,axis^.axis,14) and $0002)=$0002);
  samp^.dg00:=read_g26(axis^.baseadr,axis^.axis,22);
  samp^.dg90:=read_g26(axis^.baseadr,axis^.axis,24);
  wert:=read_g26(axis^.baseadr,axis^.axis,6);
  dummy:=read_g26(axis^.baseadr,axis^.axis,8);
  dummy:=read_g26(axis^.baseadr,axis^.axis,10);
  samp^.intp:=wert and $03FF;
END;
{----------------------------------------------------------}
procedure build_sample(var samp:single_pointr);
var
  buffer1,buffer2 : single_pointr;
  i               : byte;
begin
  New(buffer1);
  samp:=buffer1;
  for i:=0 to 128 do
    begin
      new(buffer2);
      buffer1^.next:=buffer2;
      buffer1:=buffer2;
    end;
  buffer1^.next:=nil;
end;
{----------------------------------------------------------}
procedure get_sample(axis:g26_pointr;samp:single_pointr);
var
  buffer : single_pointr;
begin
  buffer:=samp;
  get_single(axis,buffer);  (* Old value *)
  get_single(axis,buffer);
  while buffer^.next<>nil do
    begin
      buffer:=buffer^.next;
      get_single(axis,buffer);
    end;
end;
{----------------------------------------------------------}
procedure free_sample(samp:single_pointr);
var
  buffer0,buffer1 : single_pointr;
begin
  buffer0:=samp;
  while buffer0^.next<>nil do
    begin
      buffer1:=buffer0^.next;
      Dispose(buffer0);
      buffer0:=buffer1;
    end;
  Dispose(buffer0);
end;
(*________________________________________*)
END. {unit}
